/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.jedis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisCacheManager<K, V>
implements CacheManager<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JedisCacheManager.class);
    private final JedisPool pool;
    private final String cacheName;
    private final Class<V> valueType;
    private final ObjectMapper objectMapper;
    private final String updateChannel;

    public JedisCacheManager(JedisPool pool, String cacheName, Class<V> valueType) {
        this.pool = pool;
        this.cacheName = cacheName;
        this.valueType = valueType;
        this.objectMapper = new ObjectMapper();
        this.updateChannel = cacheName.concat(":update");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V getValue(K key) {
        try (Jedis jedis = this.pool.getResource();){
            String serializedValue = jedis.hget(this.cacheName, this.objectMapper.writeValueAsString(key));
            Object object = serializedValue != null ? this.objectMapper.readValue(serializedValue, this.valueType) : null;
            return (V)object;
        }
        catch (JsonProcessingException e) {
            log.warn("Exception occurred while retrieving key '{}' from cache '{}'. Message: {}", new Object[]{key, this.cacheName, e.getMessage()});
            return null;
        }
    }

    @Override
    public void setValue(K key, V value) {
        try (Jedis jedis = this.pool.getResource();){
            V oldValue = this.getValue(key);
            String serializedKey = this.objectMapper.writeValueAsString(key);
            String serializedValue = this.objectMapper.writeValueAsString(value);
            jedis.hset(this.cacheName, serializedKey, serializedValue);
            if (oldValue != null) {
                CacheUpdateEvent<K, V> updateEvent = new CacheUpdateEvent<K, V>(key, oldValue, value);
                jedis.publish(this.updateChannel, this.objectMapper.writeValueAsString(updateEvent));
            }
        }
        catch (JsonProcessingException e) {
            log.warn("Exception occurred while setting key '{}' in cache '{}'. Message: {}", new Object[]{key, this.cacheName, e.getMessage()});
            throw new RuntimeException(e);
        }
    }
}

