/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter;

import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import com.giffing.bucket4j.spring.boot.starter.context.KeyFilter;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import com.giffing.bucket4j.spring.boot.starter.service.RateLimitService;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class Bucket4JBaseConfiguration<R, P>
implements CacheUpdateListener<String, Bucket4JConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Bucket4JBaseConfiguration.class);
    private final RateLimitService rateLimitService;
    private final CacheManager<String, Bucket4JConfiguration> configCacheManager;
    private final List<MetricHandler> metricHandlers;
    private final Map<String, ExecutePredicate<R>> executePredicates;

    public FilterConfiguration<R, P> buildFilterConfig(Bucket4JConfiguration config, ProxyManagerWrapper proxyWrapper) {
        RateLimitService.RateLimitConfig rateLimitConfig = RateLimitService.RateLimitConfig.builder().rateLimits(config.getRateLimits()).metricHandlers(this.metricHandlers).executePredicates(this.executePredicates).cacheName(config.getCacheName()).configVersion(config.getBucket4JVersionNumber()).keyFunction((rl, sr) -> {
            KeyFilter keyFilter = this.rateLimitService.getKeyFilter(config.getUrl(), (RateLimit)rl);
            return keyFilter.key(sr);
        }).metrics(config.getMetrics()).proxyWrapper(proxyWrapper).build();
        RateLimitService.RateLimitConfigresult rateLimitConfigResult = this.rateLimitService.configureRateLimit(rateLimitConfig);
        FilterConfiguration<R, P> filterConfig = this.mapFilterConfiguration(config);
        rateLimitConfigResult.getRateLimitChecks().forEach(arg_0 -> filterConfig.addRateLimitCheck(arg_0));
        rateLimitConfigResult.getPostRateLimitChecks().forEach(arg_0 -> filterConfig.addPostRateLimitCheck(arg_0));
        return filterConfig;
    }

    private FilterConfiguration<R, P> mapFilterConfiguration(Bucket4JConfiguration config) {
        FilterConfiguration filterConfig = new FilterConfiguration();
        filterConfig.setUrl(config.getUrl().strip());
        filterConfig.setOrder(config.getFilterOrder().intValue());
        filterConfig.setStrategy(config.getStrategy());
        filterConfig.setHttpContentType(config.getHttpContentType());
        filterConfig.setHttpResponseBody(config.getHttpResponseBody());
        filterConfig.setHttpStatusCode(config.getHttpStatusCode());
        filterConfig.setHideHttpResponseHeaders(config.getHideHttpResponseHeaders());
        filterConfig.setHttpResponseHeaders(config.getHttpResponseHeaders());
        filterConfig.setMetrics(config.getMetrics());
        return filterConfig;
    }

    protected Bucket4JConfiguration getOrUpdateConfigurationFromCache(Bucket4JConfiguration filter) {
        if (this.configCacheManager == null || filter.getId() == null) {
            return filter;
        }
        Bucket4JConfiguration cachedFilter = this.configCacheManager.getValue(filter.getId());
        if (cachedFilter != null && cachedFilter.getBucket4JVersionNumber() >= filter.getBucket4JVersionNumber()) {
            return cachedFilter;
        }
        this.configCacheManager.setValue(filter.getId(), filter);
        return filter;
    }

    protected void setDefaults(Bucket4JBootProperties properties, Bucket4JConfiguration filter) {
        this.rateLimitService.addDefaultMetricTags(properties, filter);
        if (!StringUtils.hasLength((String)filter.getHttpResponseBody())) {
            filter.setHttpResponseBody(properties.getDefaultHttpResponseBody());
        }
        if (!StringUtils.hasLength((String)filter.getHttpContentType())) {
            filter.setHttpContentType(properties.getDefaultHttpContentType());
        }
        if (filter.getHttpStatusCode() == null) {
            filter.setHttpStatusCode(properties.getDefaultHttpStatusCode());
        }
    }

    @Generated
    public Bucket4JBaseConfiguration(RateLimitService rateLimitService, CacheManager<String, Bucket4JConfiguration> configCacheManager, List<MetricHandler> metricHandlers, Map<String, ExecutePredicate<R>> executePredicates) {
        this.rateLimitService = rateLimitService;
        this.configCacheManager = configCacheManager;
        this.metricHandlers = metricHandlers;
        this.executePredicates = executePredicates;
    }
}

