/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.filter.servlet.impl;

import com.giffing.bucket4j.spring.boot.starter.context.ExpressionParams;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitConditionMatchingStrategy;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResult;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResultWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.filter.servlet.ServletRateLimitFilter;
import com.giffing.bucket4j.spring.boot.starter.service.RateLimitService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class DefaultServletRateLimitFilter
extends OncePerRequestFilter
implements ServletRateLimitFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultServletRateLimitFilter.class);
    private FilterConfiguration<HttpServletRequest, HttpServletResponse> filterConfig;

    public DefaultServletRateLimitFilter(FilterConfiguration<HttpServletRequest, HttpServletResponse> filterConfig) {
        this.filterConfig = filterConfig;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return !request.getRequestURI().matches(this.filterConfig.getUrl());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean allConsumed = true;
        Long remainingLimit = null;
        for (RateLimitCheck rl : this.filterConfig.getRateLimitChecks()) {
            RateLimitResultWrapper wrapper = rl.rateLimit(new ExpressionParams((Object)request), null);
            if (wrapper == null || wrapper.getRateLimitResult() == null) continue;
            RateLimitResult rateLimitResult = wrapper.getRateLimitResult();
            if (!rateLimitResult.isConsumed()) {
                allConsumed = false;
                this.handleHttpResponseOnRateLimiting(response, rateLimitResult);
                break;
            }
            remainingLimit = RateLimitService.getRemainingLimit(remainingLimit, rateLimitResult);
            if (!this.filterConfig.getStrategy().equals((Object)RateLimitConditionMatchingStrategy.FIRST)) continue;
            break;
        }
        if (allConsumed) {
            if (remainingLimit != null && Boolean.FALSE.equals(this.filterConfig.getHideHttpResponseHeaders())) {
                log.debug("add-x-rate-limit-remaining-header;limit:{}", remainingLimit);
                response.setHeader("X-Rate-Limit-Remaining", "" + remainingLimit);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            this.filterConfig.getPostRateLimitChecks().forEach(rlc -> {
                RateLimitResultWrapper result = rlc.rateLimit((Object)request, (Object)response);
                if (result != null) {
                    log.debug("post-rate-limit;remaining-tokens:{}", (Object)result.getRateLimitResult().getRemainingTokens());
                }
            });
        }
    }

    private void handleHttpResponseOnRateLimiting(HttpServletResponse httpResponse, RateLimitResult rateLimitResult) throws IOException {
        httpResponse.setStatus(this.filterConfig.getHttpStatusCode().value());
        if (Boolean.FALSE.equals(this.filterConfig.getHideHttpResponseHeaders())) {
            httpResponse.setHeader("X-Rate-Limit-Retry-After-Seconds", "" + TimeUnit.NANOSECONDS.toSeconds(rateLimitResult.getNanosToWaitForRefill()));
            this.filterConfig.getHttpResponseHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)httpResponse).setHeader(arg_0, arg_1));
        }
        if (this.filterConfig.getHttpResponseBody() != null) {
            httpResponse.setContentType(this.filterConfig.getHttpContentType());
            httpResponse.getWriter().append(this.filterConfig.getHttpResponseBody());
        }
    }

    public int getOrder() {
        return this.filterConfig.getOrder();
    }

    @Override
    @Generated
    public void setFilterConfig(FilterConfiguration<HttpServletRequest, HttpServletResponse> filterConfig) {
        this.filterConfig = filterConfig;
    }
}

