/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.service;

import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.Condition;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicateDefinition;
import com.giffing.bucket4j.spring.boot.starter.context.ExpressionParams;
import com.giffing.bucket4j.spring.boot.starter.context.KeyFilter;
import com.giffing.bucket4j.spring.boot.starter.context.PostRateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResult;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResultWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricBucketListener;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricTagResult;
import com.giffing.bucket4j.spring.boot.starter.context.properties.BandWidth;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MetricTag;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Metrics;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import com.giffing.bucket4j.spring.boot.starter.exception.ExecutePredicateInstantiationException;
import com.giffing.bucket4j.spring.boot.starter.service.ExpressionService;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthBuilder;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConfigurationBuilder;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitService.class);
    private final ExpressionService expressionService;

    public <R, P> RateLimitConfigresult<R, P> configureRateLimit(RateLimitConfig<R> rateLimitConfig) {
        Map executePredicates = rateLimitConfig.getExecutePredicates();
        ArrayList rateLimitChecks = new ArrayList();
        ArrayList postRateLimitChecks = new ArrayList();
        rateLimitConfig.getRateLimits().forEach(rl -> {
            log.debug("RL: {}", (Object)rl.toString());
            BucketConfiguration bucketConfiguration = this.prepareBucket4jConfigurationBuilder((RateLimit)rl).build();
            Predicate executionPredicate = this.prepareExecutionPredicates((RateLimit)rl, executePredicates);
            Predicate skipPredicate = this.prepareSkipPredicates((RateLimit)rl, executePredicates);
            RateLimitCheck rlc = (expressionParams, overridableRateLimit) -> {
                RateLimit rlToUse = rl.copy();
                rlToUse.consumeNotNullValues(overridableRateLimit);
                boolean skipRateLimit = this.performSkipRateLimitCheck(rlToUse, executionPredicate, skipPredicate, expressionParams);
                boolean isEstimation = rlToUse.getPostExecuteCondition() != null;
                RateLimitResultWrapper rateLimitResultWrapper = null;
                if (!skipRateLimit) {
                    rateLimitResultWrapper = this.tryConsume(rateLimitConfig, expressionParams, rlToUse, isEstimation, bucketConfiguration);
                }
                return rateLimitResultWrapper;
            };
            rateLimitChecks.add(rlc);
            if (rl.getPostExecuteCondition() != null) {
                log.debug("PRL: {}", rl);
                PostRateLimitCheck postRlc = (request, response) -> {
                    ExpressionParams expressionParams = new ExpressionParams(request);
                    boolean skipRateLimit = this.performPostSkipRateLimitCheck((RateLimit)rl, executionPredicate, skipPredicate, (ExpressionParams)expressionParams, (Object)response);
                    boolean isEstimation = false;
                    RateLimitResultWrapper rateLimitResultWrapper = null;
                    if (!skipRateLimit) {
                        rateLimitResultWrapper = this.tryConsume(rateLimitConfig, (ExpressionParams)expressionParams, (RateLimit)rl, isEstimation, bucketConfiguration);
                    }
                    return rateLimitResultWrapper;
                };
                postRateLimitChecks.add(postRlc);
            }
        });
        return new RateLimitConfigresult(rateLimitChecks, postRateLimitChecks);
    }

    private <R> RateLimitResultWrapper tryConsume(RateLimitConfig<R> rateLimitConfig, ExpressionParams<R> expressionParams, RateLimit rlToUse, boolean isEstimation, BucketConfiguration bucketConfiguration) {
        List<MetricHandler> metricHandlers = rateLimitConfig.getMetricHandlers();
        String cacheName = rateLimitConfig.getCacheName();
        Metrics metrics = rateLimitConfig.getMetrics();
        BiFunction<RateLimit, ExpressionParams<R>, String> keyFunction = rateLimitConfig.getKeyFunction();
        ProxyManagerWrapper proxyWrapper = rateLimitConfig.getProxyWrapper();
        long configVersion = rateLimitConfig.getConfigVersion();
        String key = keyFunction.apply(rlToUse, expressionParams);
        MetricBucketListener metricBucketListener = this.createMetricListener(cacheName, metrics, metricHandlers, expressionParams);
        log.debug("try-and-consume;key:{};tokens:{}", (Object)key, (Object)rlToUse.getNumTokens());
        RateLimitResultWrapper rateLimitResultWrapper = proxyWrapper.tryConsumeAndReturnRemaining(key, rlToUse.getNumTokens(), isEstimation, bucketConfiguration, metricBucketListener, configVersion, rlToUse.getTokensInheritanceStrategy());
        return rateLimitResultWrapper;
    }

    private <R, P> boolean performPostSkipRateLimitCheck(RateLimit rl, Predicate<R> executionPredicate, Predicate<R> skipPredicate, ExpressionParams<R> expressionParams, P response) {
        boolean skipRateLimit = this.performSkipRateLimitCheck(rl, executionPredicate, skipPredicate, expressionParams);
        if (!skipRateLimit && rl.getPostExecuteCondition() != null) {
            Condition condition = exp -> this.expressionService.parseBoolean(rl.getPostExecuteCondition(), exp);
            skipRateLimit = !condition.evaluate(new ExpressionParams(response).addParams(expressionParams.getParams()));
            log.debug("skip-rate-limit - post-execute-condition: {}", (Object)skipRateLimit);
        }
        return skipRateLimit;
    }

    private <R> boolean performSkipRateLimitCheck(RateLimit rl, Predicate<R> executionPredicate, Predicate<R> skipPredicate, ExpressionParams<R> expressionParams) {
        boolean skipRateLimit = false;
        if (rl.getSkipCondition() != null) {
            Condition expresison = exp -> this.expressionService.parseBoolean(rl.getSkipCondition(), exp);
            skipRateLimit = expresison.evaluate(expressionParams);
            log.debug("skip-rate-limit - skip-condition: {}", (Object)skipRateLimit);
        }
        if (!skipRateLimit) {
            skipRateLimit = skipPredicate.test(expressionParams.getRootObject());
            log.debug("skip-rate-limit - skip-predicates: {}", (Object)skipRateLimit);
        }
        if (!skipRateLimit && rl.getExecuteCondition() != null) {
            Condition condition = exp -> this.expressionService.parseBoolean(rl.getExecuteCondition(), exp);
            skipRateLimit = !condition.evaluate(expressionParams);
            log.debug("skip-rate-limit - execute-condition: {}", (Object)skipRateLimit);
        }
        if (!skipRateLimit) {
            skipRateLimit = !executionPredicate.test(expressionParams.getRootObject());
            log.debug("skip-rate-limit - execute-predicates: {}", (Object)skipRateLimit);
        }
        return skipRateLimit;
    }

    public <R> List<MetricTagResult> getMetricTagResults(ExpressionParams<R> expressionParams, Metrics metrics) {
        return metrics.getTags().stream().map(metricMetaTag -> {
            String value = this.expressionService.parseString(metricMetaTag.getExpression(), expressionParams);
            return new MetricTagResult(metricMetaTag.getKey(), value, metricMetaTag.getTypes());
        }).toList();
    }

    public <R> KeyFilter<R> getKeyFilter(String url, RateLimit rateLimit) {
        return expressionParams -> {
            String value = this.expressionService.parseString(rateLimit.getCacheKey(), expressionParams);
            return url + "-" + value;
        };
    }

    private ConfigurationBuilder prepareBucket4jConfigurationBuilder(RateLimit rl) {
        ConfigurationBuilder configBuilder = BucketConfiguration.builder();
        for (BandWidth bandWidth : rl.getBandwidths()) {
            BandwidthBuilder.BandwidthBuilderBuildStage bucket4jBandWidth;
            long capacity = bandWidth.getCapacity();
            long refillCapacity = bandWidth.getRefillCapacity() != null ? bandWidth.getRefillCapacity().longValue() : bandWidth.getCapacity();
            Duration refillPeriod = Duration.of(bandWidth.getTime(), bandWidth.getUnit());
            switch (bandWidth.getRefillSpeed()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case GREEDY: {
                    BandwidthBuilder.BandwidthBuilderBuildStage bandwidthBuilderBuildStage = Bandwidth.builder().capacity(capacity).refillGreedy(refillCapacity, refillPeriod).id(bandWidth.getId());
                    break;
                }
                case INTERVAL: {
                    BandwidthBuilder.BandwidthBuilderBuildStage bandwidthBuilderBuildStage = bucket4jBandWidth = Bandwidth.builder().capacity(capacity).refillIntervally(refillCapacity, refillPeriod).id(bandWidth.getId());
                }
            }
            if (bandWidth.getInitialCapacity() != null) {
                bucket4jBandWidth = bucket4jBandWidth.initialTokens(bandWidth.getInitialCapacity().longValue());
            }
            configBuilder = configBuilder.addLimit(bucket4jBandWidth.build());
        }
        return configBuilder;
    }

    private <R> MetricBucketListener createMetricListener(String cacheName, Metrics metrics, List<MetricHandler> metricHandlers, ExpressionParams<R> expressionParams) {
        List<MetricTagResult> metricTagResults = this.getMetricTags(metrics, expressionParams);
        return new MetricBucketListener(cacheName, metricHandlers, metrics.getTypes(), metricTagResults);
    }

    private <R> List<MetricTagResult> getMetricTags(Metrics metrics, ExpressionParams<R> expressionParams) {
        return this.getMetricTagResults(expressionParams, metrics);
    }

    public void addDefaultMetricTags(Bucket4JBootProperties properties, Bucket4JConfiguration filter) {
        if (!properties.getDefaultMetricTags().isEmpty()) {
            List metricTags = filter.getMetrics().getTags();
            Set filterMetricTagKeys = metricTags.stream().map(MetricTag::getKey).collect(Collectors.toSet());
            properties.getDefaultMetricTags().forEach(defaultTag -> {
                if (!filterMetricTagKeys.contains(defaultTag.getKey())) {
                    metricTags.add(defaultTag);
                }
            });
        }
    }

    private <R> Predicate<R> prepareExecutionPredicates(RateLimit rl, Map<String, ExecutePredicate<R>> executePredicates) {
        return rl.getExecutePredicates().stream().map(p -> this.createPredicate((ExecutePredicateDefinition)p, executePredicates)).reduce(Predicate::and).orElseGet(() -> p -> true);
    }

    private <R> Predicate<R> prepareSkipPredicates(RateLimit rl, Map<String, ExecutePredicate<R>> executePredicates) {
        return rl.getSkipPredicates().stream().map(p -> this.createPredicate((ExecutePredicateDefinition)p, executePredicates)).reduce(Predicate::and).orElseGet(() -> p -> false);
    }

    protected <R> Predicate<R> createPredicate(ExecutePredicateDefinition pd, Map<String, ExecutePredicate<R>> executePredicates) {
        ExecutePredicate predicate = executePredicates.getOrDefault(pd.getName(), null);
        log.debug("create-predicate;name:{};value:{}", (Object)pd.getName(), (Object)pd.getArgs());
        try {
            ExecutePredicate newPredicateInstance = (ExecutePredicate)predicate.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return newPredicateInstance.init(pd.getArgs());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExecutePredicateInstantiationException(pd.getName(), predicate.getClass());
        }
    }

    public static long getRemainingLimit(Long remaining, RateLimitResult rateLimitResult) {
        if (rateLimitResult != null && (remaining == null || rateLimitResult.getRemainingTokens() < remaining)) {
            remaining = rateLimitResult.getRemainingTokens();
        }
        return remaining;
    }

    @Generated
    public RateLimitService(ExpressionService expressionService) {
        this.expressionService = expressionService;
    }

    public static class RateLimitConfig<R> {
        @NonNull
        private List<RateLimit> rateLimits;
        @NonNull
        private List<MetricHandler> metricHandlers;
        @NonNull
        private Map<String, ExecutePredicate<R>> executePredicates;
        @NonNull
        private String cacheName;
        @NonNull
        private ProxyManagerWrapper proxyWrapper;
        @NonNull
        private BiFunction<RateLimit, ExpressionParams<R>, String> keyFunction;
        @NonNull
        private Metrics metrics;
        private long configVersion;

        @Generated
        RateLimitConfig(@NonNull List<RateLimit> rateLimits, @NonNull List<MetricHandler> metricHandlers, @NonNull Map<String, ExecutePredicate<R>> executePredicates, @NonNull String cacheName, @NonNull ProxyManagerWrapper proxyWrapper, @NonNull BiFunction<RateLimit, ExpressionParams<R>, String> keyFunction, @NonNull Metrics metrics, long configVersion) {
            if (rateLimits == null) {
                throw new NullPointerException("rateLimits is marked non-null but is null");
            }
            if (metricHandlers == null) {
                throw new NullPointerException("metricHandlers is marked non-null but is null");
            }
            if (executePredicates == null) {
                throw new NullPointerException("executePredicates is marked non-null but is null");
            }
            if (cacheName == null) {
                throw new NullPointerException("cacheName is marked non-null but is null");
            }
            if (proxyWrapper == null) {
                throw new NullPointerException("proxyWrapper is marked non-null but is null");
            }
            if (keyFunction == null) {
                throw new NullPointerException("keyFunction is marked non-null but is null");
            }
            if (metrics == null) {
                throw new NullPointerException("metrics is marked non-null but is null");
            }
            this.rateLimits = rateLimits;
            this.metricHandlers = metricHandlers;
            this.executePredicates = executePredicates;
            this.cacheName = cacheName;
            this.proxyWrapper = proxyWrapper;
            this.keyFunction = keyFunction;
            this.metrics = metrics;
            this.configVersion = configVersion;
        }

        @Generated
        public static <R> RateLimitConfigBuilder<R> builder() {
            return new RateLimitConfigBuilder();
        }

        @NonNull
        @Generated
        public List<RateLimit> getRateLimits() {
            return this.rateLimits;
        }

        @NonNull
        @Generated
        public List<MetricHandler> getMetricHandlers() {
            return this.metricHandlers;
        }

        @NonNull
        @Generated
        public Map<String, ExecutePredicate<R>> getExecutePredicates() {
            return this.executePredicates;
        }

        @NonNull
        @Generated
        public String getCacheName() {
            return this.cacheName;
        }

        @NonNull
        @Generated
        public ProxyManagerWrapper getProxyWrapper() {
            return this.proxyWrapper;
        }

        @NonNull
        @Generated
        public BiFunction<RateLimit, ExpressionParams<R>, String> getKeyFunction() {
            return this.keyFunction;
        }

        @NonNull
        @Generated
        public Metrics getMetrics() {
            return this.metrics;
        }

        @Generated
        public long getConfigVersion() {
            return this.configVersion;
        }

        @Generated
        public void setRateLimits(@NonNull List<RateLimit> rateLimits) {
            if (rateLimits == null) {
                throw new NullPointerException("rateLimits is marked non-null but is null");
            }
            this.rateLimits = rateLimits;
        }

        @Generated
        public void setMetricHandlers(@NonNull List<MetricHandler> metricHandlers) {
            if (metricHandlers == null) {
                throw new NullPointerException("metricHandlers is marked non-null but is null");
            }
            this.metricHandlers = metricHandlers;
        }

        @Generated
        public void setExecutePredicates(@NonNull Map<String, ExecutePredicate<R>> executePredicates) {
            if (executePredicates == null) {
                throw new NullPointerException("executePredicates is marked non-null but is null");
            }
            this.executePredicates = executePredicates;
        }

        @Generated
        public void setCacheName(@NonNull String cacheName) {
            if (cacheName == null) {
                throw new NullPointerException("cacheName is marked non-null but is null");
            }
            this.cacheName = cacheName;
        }

        @Generated
        public void setProxyWrapper(@NonNull ProxyManagerWrapper proxyWrapper) {
            if (proxyWrapper == null) {
                throw new NullPointerException("proxyWrapper is marked non-null but is null");
            }
            this.proxyWrapper = proxyWrapper;
        }

        @Generated
        public void setKeyFunction(@NonNull BiFunction<RateLimit, ExpressionParams<R>, String> keyFunction) {
            if (keyFunction == null) {
                throw new NullPointerException("keyFunction is marked non-null but is null");
            }
            this.keyFunction = keyFunction;
        }

        @Generated
        public void setMetrics(@NonNull Metrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics is marked non-null but is null");
            }
            this.metrics = metrics;
        }

        @Generated
        public void setConfigVersion(long configVersion) {
            this.configVersion = configVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RateLimitConfig)) {
                return false;
            }
            RateLimitConfig other = (RateLimitConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getConfigVersion() != other.getConfigVersion()) {
                return false;
            }
            List<RateLimit> this$rateLimits = this.getRateLimits();
            List<RateLimit> other$rateLimits = other.getRateLimits();
            if (this$rateLimits == null ? other$rateLimits != null : !((Object)this$rateLimits).equals(other$rateLimits)) {
                return false;
            }
            List<MetricHandler> this$metricHandlers = this.getMetricHandlers();
            List<MetricHandler> other$metricHandlers = other.getMetricHandlers();
            if (this$metricHandlers == null ? other$metricHandlers != null : !((Object)this$metricHandlers).equals(other$metricHandlers)) {
                return false;
            }
            Map<String, ExecutePredicate<R>> this$executePredicates = this.getExecutePredicates();
            Map<String, ExecutePredicate<R>> other$executePredicates = other.getExecutePredicates();
            if (this$executePredicates == null ? other$executePredicates != null : !((Object)this$executePredicates).equals(other$executePredicates)) {
                return false;
            }
            String this$cacheName = this.getCacheName();
            String other$cacheName = other.getCacheName();
            if (this$cacheName == null ? other$cacheName != null : !this$cacheName.equals(other$cacheName)) {
                return false;
            }
            ProxyManagerWrapper this$proxyWrapper = this.getProxyWrapper();
            ProxyManagerWrapper other$proxyWrapper = other.getProxyWrapper();
            if (this$proxyWrapper == null ? other$proxyWrapper != null : !this$proxyWrapper.equals(other$proxyWrapper)) {
                return false;
            }
            BiFunction<RateLimit, ExpressionParams<R>, String> this$keyFunction = this.getKeyFunction();
            BiFunction<RateLimit, ExpressionParams<R>, String> other$keyFunction = other.getKeyFunction();
            if (this$keyFunction == null ? other$keyFunction != null : !this$keyFunction.equals(other$keyFunction)) {
                return false;
            }
            Metrics this$metrics = this.getMetrics();
            Metrics other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RateLimitConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $configVersion = this.getConfigVersion();
            result = result * 59 + (int)($configVersion >>> 32 ^ $configVersion);
            List<RateLimit> $rateLimits = this.getRateLimits();
            result = result * 59 + ($rateLimits == null ? 43 : ((Object)$rateLimits).hashCode());
            List<MetricHandler> $metricHandlers = this.getMetricHandlers();
            result = result * 59 + ($metricHandlers == null ? 43 : ((Object)$metricHandlers).hashCode());
            Map<String, ExecutePredicate<R>> $executePredicates = this.getExecutePredicates();
            result = result * 59 + ($executePredicates == null ? 43 : ((Object)$executePredicates).hashCode());
            String $cacheName = this.getCacheName();
            result = result * 59 + ($cacheName == null ? 43 : $cacheName.hashCode());
            ProxyManagerWrapper $proxyWrapper = this.getProxyWrapper();
            result = result * 59 + ($proxyWrapper == null ? 43 : $proxyWrapper.hashCode());
            BiFunction<RateLimit, ExpressionParams<R>, String> $keyFunction = this.getKeyFunction();
            result = result * 59 + ($keyFunction == null ? 43 : $keyFunction.hashCode());
            Metrics $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RateLimitService.RateLimitConfig(rateLimits=" + String.valueOf(this.getRateLimits()) + ", metricHandlers=" + String.valueOf(this.getMetricHandlers()) + ", executePredicates=" + String.valueOf(this.getExecutePredicates()) + ", cacheName=" + this.getCacheName() + ", proxyWrapper=" + String.valueOf(this.getProxyWrapper()) + ", keyFunction=" + String.valueOf(this.getKeyFunction()) + ", metrics=" + String.valueOf(this.getMetrics()) + ", configVersion=" + this.getConfigVersion() + ")";
        }

        @Generated
        public static class RateLimitConfigBuilder<R> {
            @Generated
            private List<RateLimit> rateLimits;
            @Generated
            private List<MetricHandler> metricHandlers;
            @Generated
            private Map<String, ExecutePredicate<R>> executePredicates;
            @Generated
            private String cacheName;
            @Generated
            private ProxyManagerWrapper proxyWrapper;
            @Generated
            private BiFunction<RateLimit, ExpressionParams<R>, String> keyFunction;
            @Generated
            private Metrics metrics;
            @Generated
            private long configVersion;

            @Generated
            RateLimitConfigBuilder() {
            }

            @Generated
            public RateLimitConfigBuilder<R> rateLimits(@NonNull List<RateLimit> rateLimits) {
                if (rateLimits == null) {
                    throw new NullPointerException("rateLimits is marked non-null but is null");
                }
                this.rateLimits = rateLimits;
                return this;
            }

            @Generated
            public RateLimitConfigBuilder<R> metricHandlers(@NonNull List<MetricHandler> metricHandlers) {
                if (metricHandlers == null) {
                    throw new NullPointerException("metricHandlers is marked non-null but is null");
                }
                this.metricHandlers = metricHandlers;
                return this;
            }

            @Generated
            public RateLimitConfigBuilder<R> executePredicates(@NonNull Map<String, ExecutePredicate<R>> executePredicates) {
                if (executePredicates == null) {
                    throw new NullPointerException("executePredicates is marked non-null but is null");
                }
                this.executePredicates = executePredicates;
                return this;
            }

            @Generated
            public RateLimitConfigBuilder<R> cacheName(@NonNull String cacheName) {
                if (cacheName == null) {
                    throw new NullPointerException("cacheName is marked non-null but is null");
                }
                this.cacheName = cacheName;
                return this;
            }

            @Generated
            public RateLimitConfigBuilder<R> proxyWrapper(@NonNull ProxyManagerWrapper proxyWrapper) {
                if (proxyWrapper == null) {
                    throw new NullPointerException("proxyWrapper is marked non-null but is null");
                }
                this.proxyWrapper = proxyWrapper;
                return this;
            }

            @Generated
            public RateLimitConfigBuilder<R> keyFunction(@NonNull BiFunction<RateLimit, ExpressionParams<R>, String> keyFunction) {
                if (keyFunction == null) {
                    throw new NullPointerException("keyFunction is marked non-null but is null");
                }
                this.keyFunction = keyFunction;
                return this;
            }

            @Generated
            public RateLimitConfigBuilder<R> metrics(@NonNull Metrics metrics) {
                if (metrics == null) {
                    throw new NullPointerException("metrics is marked non-null but is null");
                }
                this.metrics = metrics;
                return this;
            }

            @Generated
            public RateLimitConfigBuilder<R> configVersion(long configVersion) {
                this.configVersion = configVersion;
                return this;
            }

            @Generated
            public RateLimitConfig<R> build() {
                return new RateLimitConfig<R>(this.rateLimits, this.metricHandlers, this.executePredicates, this.cacheName, this.proxyWrapper, this.keyFunction, this.metrics, this.configVersion);
            }

            @Generated
            public String toString() {
                return "RateLimitService.RateLimitConfig.RateLimitConfigBuilder(rateLimits=" + String.valueOf(this.rateLimits) + ", metricHandlers=" + String.valueOf(this.metricHandlers) + ", executePredicates=" + String.valueOf(this.executePredicates) + ", cacheName=" + this.cacheName + ", proxyWrapper=" + String.valueOf(this.proxyWrapper) + ", keyFunction=" + String.valueOf(this.keyFunction) + ", metrics=" + String.valueOf(this.metrics) + ", configVersion=" + this.configVersion + ")";
            }
        }
    }

    public static class RateLimitConfigresult<R, P> {
        private List<RateLimitCheck<R>> rateLimitChecks;
        private List<PostRateLimitCheck<R, P>> postRateLimitChecks;

        @Generated
        RateLimitConfigresult(List<RateLimitCheck<R>> rateLimitChecks, List<PostRateLimitCheck<R, P>> postRateLimitChecks) {
            this.rateLimitChecks = rateLimitChecks;
            this.postRateLimitChecks = postRateLimitChecks;
        }

        @Generated
        public static <R, P> RateLimitConfigresultBuilder<R, P> builder() {
            return new RateLimitConfigresultBuilder();
        }

        @Generated
        public List<RateLimitCheck<R>> getRateLimitChecks() {
            return this.rateLimitChecks;
        }

        @Generated
        public List<PostRateLimitCheck<R, P>> getPostRateLimitChecks() {
            return this.postRateLimitChecks;
        }

        @Generated
        public void setRateLimitChecks(List<RateLimitCheck<R>> rateLimitChecks) {
            this.rateLimitChecks = rateLimitChecks;
        }

        @Generated
        public void setPostRateLimitChecks(List<PostRateLimitCheck<R, P>> postRateLimitChecks) {
            this.postRateLimitChecks = postRateLimitChecks;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RateLimitConfigresult)) {
                return false;
            }
            RateLimitConfigresult other = (RateLimitConfigresult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<RateLimitCheck<R>> this$rateLimitChecks = this.getRateLimitChecks();
            List<RateLimitCheck<R>> other$rateLimitChecks = other.getRateLimitChecks();
            if (this$rateLimitChecks == null ? other$rateLimitChecks != null : !((Object)this$rateLimitChecks).equals(other$rateLimitChecks)) {
                return false;
            }
            List<PostRateLimitCheck<R, P>> this$postRateLimitChecks = this.getPostRateLimitChecks();
            List<PostRateLimitCheck<R, P>> other$postRateLimitChecks = other.getPostRateLimitChecks();
            return !(this$postRateLimitChecks == null ? other$postRateLimitChecks != null : !((Object)this$postRateLimitChecks).equals(other$postRateLimitChecks));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RateLimitConfigresult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<RateLimitCheck<R>> $rateLimitChecks = this.getRateLimitChecks();
            result = result * 59 + ($rateLimitChecks == null ? 43 : ((Object)$rateLimitChecks).hashCode());
            List<PostRateLimitCheck<R, P>> $postRateLimitChecks = this.getPostRateLimitChecks();
            result = result * 59 + ($postRateLimitChecks == null ? 43 : ((Object)$postRateLimitChecks).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RateLimitService.RateLimitConfigresult(rateLimitChecks=" + String.valueOf(this.getRateLimitChecks()) + ", postRateLimitChecks=" + String.valueOf(this.getPostRateLimitChecks()) + ")";
        }

        @Generated
        public static class RateLimitConfigresultBuilder<R, P> {
            @Generated
            private List<RateLimitCheck<R>> rateLimitChecks;
            @Generated
            private List<PostRateLimitCheck<R, P>> postRateLimitChecks;

            @Generated
            RateLimitConfigresultBuilder() {
            }

            @Generated
            public RateLimitConfigresultBuilder<R, P> rateLimitChecks(List<RateLimitCheck<R>> rateLimitChecks) {
                this.rateLimitChecks = rateLimitChecks;
                return this;
            }

            @Generated
            public RateLimitConfigresultBuilder<R, P> postRateLimitChecks(List<PostRateLimitCheck<R, P>> postRateLimitChecks) {
                this.postRateLimitChecks = postRateLimitChecks;
                return this;
            }

            @Generated
            public RateLimitConfigresult<R, P> build() {
                return new RateLimitConfigresult<R, P>(this.rateLimitChecks, this.postRateLimitChecks);
            }

            @Generated
            public String toString() {
                return "RateLimitService.RateLimitConfigresult.RateLimitConfigresultBuilder(rateLimitChecks=" + String.valueOf(this.rateLimitChecks) + ", postRateLimitChecks=" + String.valueOf(this.postRateLimitChecks) + ")";
            }
        }
    }
}

