/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.utils;

import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public class Bucket4JUtils {
    public static ResponseEntity<String> validateConfigurationUpdate(Bucket4JConfiguration oldConfig, Bucket4JConfiguration newConfig) {
        if (oldConfig == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("No filter with id '" + newConfig.getId() + "' could be found."));
        }
        if (oldConfig.getBucket4JVersionNumber() >= newConfig.getBucket4JVersionNumber()) {
            return ResponseEntity.badRequest().body((Object)"The new configuration should have a higher version than the current configuration.");
        }
        ResponseEntity<String> response = Bucket4JUtils.validateFieldEquality("filterMethod", oldConfig.getFilterMethod(), newConfig.getFilterMethod());
        if (response != null) {
            return response;
        }
        response = Bucket4JUtils.validateFieldEquality("filterOrder", oldConfig.getFilterOrder(), newConfig.getFilterOrder());
        if (response != null) {
            return response;
        }
        return Bucket4JUtils.validateFieldEquality("cacheName", oldConfig.getCacheName(), newConfig.getCacheName());
    }

    private static ResponseEntity<String> validateFieldEquality(String fieldName, Object oldValue, Object newValue) {
        if (!Objects.equals(oldValue, newValue)) {
            String errorMessage = String.format("It is not possible to modify the %s of an existing filter. Expected the field to be '%s' but is '%s'.", fieldName, oldValue, newValue);
            return ResponseEntity.badRequest().body((Object)errorMessage);
        }
        return null;
    }

    @Generated
    private Bucket4JUtils() {
    }
}

