/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.zuul;

import com.giffing.bucket4j.spring.boot.starter.config.Bucket4JBaseConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.springboot.SpringBootActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.zuul.ZuulRateLimitFilter;
import com.netflix.zuul.FilterFactory;
import io.github.bucket4j.grid.jcache.JCache;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

@Configuration
@ConditionalOnProperty(prefix="bucket4j", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={FilterFactory.class, JCache.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@ConditionalOnBean(value={SyncCacheResolver.class})
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
@Import(value={Bucket4jCacheConfiguration.class, SpringBootActuatorConfig.class})
public class Bucket4JAutoConfigurationZuul
extends Bucket4JBaseConfiguration<HttpServletRequest> {
    private Logger log = LoggerFactory.getLogger(Bucket4JAutoConfigurationZuul.class);
    @Autowired
    private Bucket4JBootProperties properties;
    @Autowired
    private ConfigurableBeanFactory beanFactory;
    @Autowired
    private GenericWebApplicationContext context;
    @Autowired
    private SyncCacheResolver cacheResolver;

    @Bean
    @Qualifier(value="ZUUL")
    public Bucket4jConfigurationHolder zuulConfigurationHolder() {
        return new Bucket4jConfigurationHolder();
    }

    @Bean
    public ExpressionParser zuulExpressionParser() {
        SpelParserConfiguration config = new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, this.getClass().getClassLoader());
        SpelExpressionParser parser = new SpelExpressionParser(config);
        return parser;
    }

    @PostConstruct
    public void initFilters() {
        AtomicInteger filterCount = new AtomicInteger(0);
        this.properties.getFilters().stream().filter(filter -> !StringUtils.isEmpty((Object)filter.getUrl()) && filter.getFilterMethod().equals((Object)FilterMethod.ZUUL)).map(filter -> {
            filterCount.incrementAndGet();
            FilterConfiguration filterConfig = this.buildFilterConfig((Bucket4JConfiguration)filter, this.cacheResolver.resolve(filter.getCacheName()), this.zuulExpressionParser(), this.beanFactory);
            this.zuulConfigurationHolder().addFilterConfiguration(filter);
            this.log.info("create-zuul-filter;{};{};{}", new Object[]{filterCount, filter.getCacheName(), filter.getUrl()});
            return new ZuulRateLimitFilter(filterConfig);
        }).forEach(filter -> this.context.registerBean("bucket4JZuulFilter" + filterCount, ZuulRateLimitFilter.class, () -> filter, new BeanDefinitionCustomizer[0]));
    }
}

