/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.servlet;

import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitConditionMatchingStrategy;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import io.github.bucket4j.ConsumptionProbe;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class ServletRequestFilter
extends OncePerRequestFilter
implements Ordered {
    private FilterConfiguration<HttpServletRequest> filterConfig;

    public ServletRequestFilter(FilterConfiguration<HttpServletRequest> filterConfig) {
        this.filterConfig = filterConfig;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return !request.getRequestURI().matches(this.filterConfig.getUrl());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        boolean allConsumed = true;
        Long remainingLimit = null;
        for (RateLimitCheck rl : this.filterConfig.getRateLimitChecks()) {
            ConsumptionProbeHolder probeHolder = rl.rateLimit((Object)request, false);
            if (probeHolder == null || probeHolder.getConsumptionProbe() == null) continue;
            ConsumptionProbe probe = probeHolder.getConsumptionProbe();
            if (!probe.isConsumed()) {
                allConsumed = false;
                this.handleHttpResponseOnRateLimiting(httpResponse, probe);
                break;
            }
            remainingLimit = this.getRemainingLimit(remainingLimit, probe);
            if (!this.filterConfig.getStrategy().equals((Object)RateLimitConditionMatchingStrategy.FIRST)) continue;
            break;
        }
        if (allConsumed) {
            if (remainingLimit != null) {
                httpResponse.setHeader("X-Rate-Limit-Remaining", "" + remainingLimit);
            }
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private void handleHttpResponseOnRateLimiting(HttpServletResponse httpResponse, ConsumptionProbe probe) throws IOException {
        httpResponse.setStatus(429);
        httpResponse.setHeader("X-Rate-Limit-Retry-After-Seconds", "" + TimeUnit.NANOSECONDS.toSeconds(probe.getNanosToWaitForRefill()));
        httpResponse.setContentType("application/json");
        httpResponse.getWriter().append(this.filterConfig.getHttpResponseBody());
    }

    private long getRemainingLimit(Long remaining, ConsumptionProbe probe) {
        if (probe != null) {
            if (remaining == null) {
                remaining = probe.getRemainingTokens();
            } else if (probe.getRemainingTokens() < remaining) {
                remaining = probe.getRemainingTokens();
            }
        }
        return remaining;
    }

    public int getOrder() {
        return this.filterConfig.getOrder();
    }
}

