/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.zuul;

import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitConditionMatchingStrategy;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import io.github.bucket4j.ConsumptionProbe;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;

public class ZuulRateLimitFilter
extends ZuulFilter {
    private FilterConfiguration<HttpServletRequest> filterConfig;

    public ZuulRateLimitFilter(FilterConfiguration<HttpServletRequest> filterConfig) {
        this.filterConfig = filterConfig;
    }

    public Object run() {
        RequestContext context = this.getCurrentRequestContext();
        HttpServletRequest request = context.getRequest();
        Long remainingLimit = null;
        for (RateLimitCheck rl : this.filterConfig.getRateLimitChecks()) {
            ConsumptionProbeHolder probeHolder = rl.rateLimit((Object)request, false);
            if (probeHolder == null || probeHolder.getConsumptionProbe() == null) continue;
            ConsumptionProbe probe = probeHolder.getConsumptionProbe();
            if (!probe.isConsumed()) {
                context.setResponseStatusCode(HttpStatus.TOO_MANY_REQUESTS.value());
                context.addZuulResponseHeader("X-Rate-Limit-Retry-After-Seconds", "" + TimeUnit.NANOSECONDS.toSeconds(probe.getNanosToWaitForRefill()));
                context.setResponseBody(this.filterConfig.getHttpResponseBody());
                context.setSendZuulResponse(false);
                break;
            }
            remainingLimit = this.getRemainingLimit(remainingLimit, probe);
            if (!this.filterConfig.getStrategy().equals((Object)RateLimitConditionMatchingStrategy.FIRST)) continue;
            break;
        }
        return null;
    }

    protected RequestContext getCurrentRequestContext() {
        return RequestContext.getCurrentContext();
    }

    private long getRemainingLimit(Long remaining, ConsumptionProbe probe) {
        if (probe != null) {
            if (remaining == null) {
                remaining = probe.getRemainingTokens();
            } else if (probe.getRemainingTokens() < remaining) {
                remaining = probe.getRemainingTokens();
            }
        }
        return remaining;
    }

    public boolean shouldFilter() {
        RequestContext currentContext = RequestContext.getCurrentContext();
        HttpServletRequest request = currentContext.getRequest();
        String requestURI = request.getRequestURI();
        return requestURI.matches(this.filterConfig.getUrl());
    }

    public int filterOrder() {
        return this.filterConfig.getOrder();
    }

    public String filterType() {
        return "pre";
    }
}

