/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis;

import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.AbstractBinaryTransaction;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import java.util.concurrent.CompletableFuture;
import org.springframework.data.redis.core.RedisTemplate;

class RedisProxyManager
extends AbstractProxyManager<String> {
    private final RedisTemplate<String, byte[]> redisTemplate;
    private final String cacheName;

    protected RedisProxyManager(RedisTemplate<String, byte[]> redisTemplate, String cacheName) {
        super(ClientSideConfig.getDefault());
        this.redisTemplate = redisTemplate;
        this.cacheName = cacheName;
    }

    public <T> CommandResult<T> execute(String key, Request<T> request) {
        byte[] resultBytes = new BucketProcessor<T>(this.redisTemplate).process(this.buildRedisKey(key), request);
        return InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)request.getBackwardCompatibilityVersion());
    }

    public void removeProxy(String key) {
        this.redisTemplate.delete((Object)this.buildRedisKey(key));
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(String key, Request<T> request) {
        throw new UnsupportedOperationException();
    }

    protected CompletableFuture<Void> removeAsync(String key) {
        throw new UnsupportedOperationException();
    }

    private String buildRedisKey(String key) {
        return this.cacheName + "." + key;
    }

    private static class BucketProcessor<T> {
        private final RedisTemplate<String, byte[]> redisTemplate;

        public BucketProcessor(RedisTemplate<String, byte[]> redisTemplate) {
            this.redisTemplate = redisTemplate;
        }

        public byte[] process(String key, Request<T> request) {
            return new RedisTransaction(this.redisTemplate, key, InternalSerializationHelper.serializeRequest(request)).execute();
        }
    }

    private static class RedisTransaction
    extends AbstractBinaryTransaction {
        private final RedisTemplate<String, byte[]> redisTemplate;
        private final String key;

        private RedisTransaction(RedisTemplate<String, byte[]> redisTemplate, String key, byte[] requestBytes) {
            super(requestBytes);
            this.redisTemplate = redisTemplate;
            this.key = key;
        }

        public boolean exists() {
            return this.redisTemplate.hasKey((Object)this.key);
        }

        protected byte[] getRawState() {
            return (byte[])this.redisTemplate.opsForValue().get((Object)this.key);
        }

        protected void setRawState(byte[] stateBytes) {
            this.redisTemplate.opsForValue().set((Object)this.key, (Object)stateBytes);
        }
    }
}

