/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.jcache;

import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.jcache.JCacheCacheResolver;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Caching.class, JCacheCacheManager.class})
@ConditionalOnBean(value={CacheManager.class})
@ConditionalOnMissingBean(value={SyncCacheResolver.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="jcache", matchIfMissing=true)
public class JCacheBucket4jConfiguration {
    private CacheManager cacheManager;

    public JCacheBucket4jConfiguration(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Bean
    public SyncCacheResolver bucket4jCacheResolver() {
        return new JCacheCacheResolver(this.cacheManager);
    }
}

