/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.grid.infinispan.InfinispanProxyManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.manager.CacheContainer;

public class InfinispanCacheResolver
implements AsyncCacheResolver {
    private CacheContainer cacheContainer;

    public InfinispanCacheResolver(CacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    @Override
    public ProxyManagerWrapper resolve(String cacheName) {
        Cache cache = this.cacheContainer.getCache(cacheName);
        InfinispanProxyManager infinispanProxyManager = new InfinispanProxyManager(InfinispanCacheResolver.toMap((Cache<String, byte[]>)cache));
        return (key, numTokens, bucketConfiguration, metricsListener) -> {
            AsyncBucketProxy bucket = infinispanProxyManager.asAsync().builder().build((Object)key, bucketConfiguration).toListenable((BucketListener)metricsListener);
            return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()));
        };
    }

    private static FunctionalMap.ReadWriteMap<String, byte[]> toMap(Cache<String, byte[]> cache) {
        AdvancedCache advancedCache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create((AdvancedCache)advancedCache);
        return ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
    }
}

