/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.web;

import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.app.WicketBootWebApplication;
import com.giffing.wicket.spring.boot.starter.web.WicketWebInitializerProperties;
import com.giffing.wicket.spring.boot.starter.web.config.WicketWebInitializerAutoConfig;
import com.giffing.wicket.spring.boot.starter.web.config.WicketWebInitializerConfig;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.wicket.spring.SpringWebApplicationFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={WicketWebInitializerAutoConfig.class})
@EnableConfigurationProperties(value={WicketWebInitializerProperties.class})
public class WicketWebInitializer
implements ServletContextInitializer {
    public static final String WICKET_FILTERNAME = "wicket-filter";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private WicketWebInitializerConfig wicketWebInitializerConfig;
    @Autowired
    private WicketWebInitializerProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void onStartup(ServletContext servletContext) throws ServletException {
        String[] beanNamesForType = this.applicationContext.getBeanNamesForType(WicketBootWebApplication.class);
        if (beanNamesForType.length != 1) {
            throw new IllegalStateException("Could not find exactly one bean for type WicketBootWebApplication " + beanNamesForType.length);
        }
        FilterRegistration.Dynamic filter = servletContext.addFilter(WICKET_FILTERNAME, this.wicketWebInitializerConfig.filterClass());
        filter.setInitParameter("applicationFactoryClassName", SpringWebApplicationFactory.class.getName());
        filter.setInitParameter("applicationBean", beanNamesForType[0]);
        filter.setInitParameter("filterMappingUrlPattern", this.props.getFilterMappingParam());
        filter.addMappingForUrlPatterns(EnumSet.copyOf(this.props.getDispatcherTypes()), false, new String[]{this.props.getFilterMappingParam()});
        Map<String, String> initParameters = this.props.getInitParameters();
        for (Map.Entry<String, String> initParam : initParameters.entrySet()) {
            filter.setInitParameter(initParam.getKey(), initParam.getValue());
        }
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("wicketFilterName", (Object)WICKET_FILTERNAME).withDetail("wicketFilterClass", this.wicketWebInitializerConfig.filterClass()).withDetail("properties", (Object)this.props).build());
    }
}

