/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.gfc.concurrent;

import com.gilt.gfc.concurrent.Batcher;
import com.gilt.gfc.logging.Loggable;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc!B\u0001\u0003\u0005\tQ!a\u0003\"bi\u000eDWM]%na2T!a\u0001\u0003\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u0006\r\u0005\u0019qMZ2\u000b\u0005\u001dA\u0011\u0001B4jYRT\u0011!C\u0001\u0004G>lWCA\u0006\u0019'\u0011\u0001AB\u0005\u0012\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\r\u0019BCF\u0007\u0002\u0005%\u0011QC\u0001\u0002\b\u0005\u0006$8\r[3s!\t9\u0002\u0004\u0004\u0001\u0005\u000be\u0001!\u0019A\u000e\u0003\u0003I\u001b\u0001!\u0005\u0002\u001d?A\u0011Q\"H\u0005\u0003=9\u0011qAT8uQ&tw\r\u0005\u0002\u000eA%\u0011\u0011E\u0004\u0002\u0004\u0003:L\bCA\u0012'\u001b\u0005!#BA\u0013\u0005\u0003\u001dawnZ4j]\u001eL!a\n\u0013\u0003\u00111{wmZ1cY\u0016D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0005]\u0006lW\r\u0005\u0002,e9\u0011A\u0006\r\t\u0003[9i\u0011A\f\u0006\u0003_i\ta\u0001\u0010:p_Rt\u0014BA\u0019\u000f\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Er\u0001\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002'5\f\u0007pT;ugR\fg\u000eZ5oO\u000e{WO\u001c;\u0011\u00055A\u0014BA\u001d\u000f\u0005\rIe\u000e\u001e\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u00051R.\u0019=PkR\u001cH/\u00198eS:<G)\u001e:bi&|g\u000e\u0005\u0002>\u00036\taH\u0003\u0002@\u0001\u0006AA-\u001e:bi&|gN\u0003\u0002\u0004\u001d%\u0011!I\u0010\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011!!\u0005A!A!\u0002\u0013)\u0015aC:vE6LGOQ1uG\"\u0004B!\u0004$I#&\u0011qI\u0004\u0002\n\rVt7\r^5p]F\u00022!\u0013(\u0017\u001d\tQEJ\u0004\u0002.\u0017&\tq\"\u0003\u0002N\u001d\u00059\u0001/Y2lC\u001e,\u0017BA(Q\u0005!IE/\u001a:bE2,'BA'\u000f!\ti!+\u0003\u0002T\u001d\t!QK\\5u\u0011!)\u0006A!A!\u0002\u00131\u0016\u0001C3yK\u000e,Ho\u001c:\u0011\u0005]CV\"\u0001!\n\u0005e\u0003%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015Y\u0006\u0001\"\u0001]\u0003\u0019a\u0014N\\5u}Q1QLX0aC\n\u00042a\u0005\u0001\u0017\u0011\u0015I#\f1\u0001+\u0011\u00151$\f1\u00018\u0011\u0015Y$\f1\u0001=\u0011\u0015!%\f1\u0001F\u0011\u0015)&\f1\u0001W\u0011\u0019!\u0007\u0001)A\u0005K\u0006QQ-\u001c9us\n\u000bGo\u00195\u0011\t51w\u0007[\u0005\u0003O:\u0011a\u0001V;qY\u0016\u0014\u0004cA5o-5\t!N\u0003\u0002lY\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003[:\t!bY8mY\u0016\u001cG/[8o\u0013\ty'N\u0001\u0004WK\u000e$xN\u001d\u0005\u0007c\u0002\u0001\u000b\u0011\u0002:\u0002\u0019\r,(O]3oi\n\u000bGo\u00195\u0011\u0007M\\X-D\u0001u\u0015\t)h/\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0007]T!\u0001_=\u0002\tU$\u0018\u000e\u001c\u0006\u0002u\u0006!!.\u0019<b\u0013\taHOA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f\u0011\u0019q\b\u0001)Q\u0005\u007f\u0006I\u0011n\u001d*v]:Lgn\u001a\t\u0004\u001b\u0005\u0005\u0011bAA\u0002\u001d\t9!i\\8mK\u0006t\u0007fA?\u0002\bA\u0019Q\"!\u0003\n\u0007\u0005-aB\u0001\u0005w_2\fG/\u001b7f\u0011!\ty\u0001\u0001Q\u0001\n\u0005E\u0011!\u00034mkNDG+Y:l!\u0011\t\u0019\"!\u0006\u000e\u0003]L1!a\u0006x\u0005%!\u0016.\\3s)\u0006\u001c8\u000e\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u000f\u0003\u0015!\u0018.\\3s!\u0011\t\u0019\"a\b\n\u0007\u0005\u0005rOA\u0003US6,'\u000fC\u0004\u0002&\u0001!\t%a\n\u0002\u0007\u0005$G\rF\u0002R\u0003SAq!a\u000b\u0002$\u0001\u0007a#A\u0001sQ\u0011\t\u0019#a\f\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\t\u0019DA\u0004uC&d'/Z2\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@\u0005)a\r\\;tQR\t\u0011\u000b\u000b\u0003\u0002<\u0005=\u0002bBA#\u0001\u0011\u0005\u0013qH\u0001\tg\",H\u000fZ8x]\"A\u0011\u0011\n\u0001!\n\u0013\tY%A\btC\u001a,7+\u001e2nSR\u0014\u0015\r^2i)\r\t\u0016Q\n\u0005\t\u0003\u001f\n9\u00051\u0001\u0002R\u00059!/Z2pe\u0012\u001c\b\u0003B%\u0002TYI!a\u001c)")
public final class BatcherImpl<R>
implements Batcher<R>,
Loggable {
    private final String name;
    private final int maxOutstandingCount;
    private final Function1<Iterable<R>, BoxedUnit> submitBatch;
    private final Tuple2<Object, Vector<R>> emptyBatch;
    private final AtomicReference<Tuple2<Object, Vector<R>>> currentBatch;
    public volatile boolean com$gilt$gfc$concurrent$BatcherImpl$$isRunning;
    private final TimerTask flushTask;
    private final Timer timer;
    private final transient Logger com$gilt$gfc$logging$Loggable$$logger;

    public void trace(Function0<String> message) {
        Loggable.trace$((Loggable)this, message);
    }

    public void trace(Function0<String> message, Throwable ex) {
        Loggable.trace$((Loggable)this, message, (Throwable)ex);
    }

    public void debug(Function0<String> message) {
        Loggable.debug$((Loggable)this, message);
    }

    public void debug(Function0<String> message, Throwable ex) {
        Loggable.debug$((Loggable)this, message, (Throwable)ex);
    }

    public void info(Function0<String> message) {
        Loggable.info$((Loggable)this, message);
    }

    public void info(Function0<String> message, Throwable ex) {
        Loggable.info$((Loggable)this, message, (Throwable)ex);
    }

    public void warn(Function0<String> message) {
        Loggable.warn$((Loggable)this, message);
    }

    public void warn(Function0<String> message, Throwable ex) {
        Loggable.warn$((Loggable)this, message, (Throwable)ex);
    }

    public void error(Throwable ex) {
        Loggable.error$((Loggable)this, (Throwable)ex);
    }

    public void error(Function0<String> message) {
        Loggable.error$((Loggable)this, message);
    }

    public void error(Function0<String> message, Throwable ex) {
        Loggable.error$((Loggable)this, message, (Throwable)ex);
    }

    public void fatal(Throwable ex) {
        Loggable.fatal$((Loggable)this, (Throwable)ex);
    }

    public void fatal(Function0<String> message) {
        Loggable.fatal$((Loggable)this, message);
    }

    public void fatal(Function0<String> message, Throwable ex) {
        Loggable.fatal$((Loggable)this, message, (Throwable)ex);
    }

    public Logger com$gilt$gfc$logging$Loggable$$logger() {
        return this.com$gilt$gfc$logging$Loggable$$logger;
    }

    public final void com$gilt$gfc$logging$Loggable$_setter_$com$gilt$gfc$logging$Loggable$$logger_$eq(Logger x$1) {
        this.com$gilt$gfc$logging$Loggable$$logger = x$1;
    }

    @Override
    public void add(R r) {
        block4: {
            BoxedUnit boxedUnit;
            while (true) {
                Predef$.MODULE$.require(this.com$gilt$gfc$concurrent$BatcherImpl$$isRunning, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " batcher is shutting down, can not add any more records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.name})));
                Tuple2<Object, Vector<R>> tuple2 = this.currentBatch.get();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int batchSize = tuple2._1$mcI$sp();
                Vector records = (Vector)tuple2._2();
                Tuple3 tuple3 = new Tuple3(tuple2, (Object)BoxesRunTime.boxToInteger((int)batchSize), (Object)records);
                Tuple3 tuple32 = tuple3;
                Tuple2 b = (Tuple2)tuple32._1();
                int batchSize2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
                Vector records2 = (Vector)tuple32._3();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(batchSize2 + 1)), records2.$colon$plus(r, Vector$.MODULE$.canBuildFrom()));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                int newBatchSize = tuple22._1$mcI$sp();
                Vector newRecords = (Vector)tuple22._2();
                Tuple3 tuple33 = new Tuple3((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)newBatchSize), (Object)newRecords);
                Tuple3 tuple34 = tuple33;
                Tuple2 b1 = (Tuple2)tuple34._1();
                int newBatchSize2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
                Vector newRecords2 = (Vector)tuple34._3();
                if (newBatchSize2 >= this.maxOutstandingCount) {
                    if (!this.currentBatch.compareAndSet(b, this.emptyBatch)) continue;
                    this.safeSubmitBatch(newRecords2);
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (this.currentBatch.compareAndSet(b, b1)) break;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void flush() {
        Vector records;
        Tuple2 b;
        do {
            Tuple2<Object, Vector<R>> tuple2;
            if ((tuple2 = this.currentBatch.get()) == null) {
                throw new MatchError(tuple2);
            }
            Vector records2 = (Vector)tuple2._2();
            Tuple2 tuple22 = new Tuple2(tuple2, (Object)records2);
            Tuple2 tuple23 = tuple22;
            b = (Tuple2)tuple23._1();
            records = (Vector)tuple23._2();
        } while (!this.currentBatch.compareAndSet(b, this.emptyBatch));
        this.safeSubmitBatch(records);
    }

    @Override
    public void shutdown() {
        this.com$gilt$gfc$concurrent$BatcherImpl$$isRunning = false;
        this.timer.cancel();
        this.flush();
    }

    private void safeSubmitBatch(Vector<R> records) {
        if (!records.isEmpty()) {
            try {
                this.submitBatch.apply(records);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to flush ", " batch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.name, e.getMessage()})), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
    }

    public BatcherImpl(String name, int maxOutstandingCount, FiniteDuration maxOutstandingDuration, Function1<Iterable<R>, BoxedUnit> submitBatch, ExecutionContext executor) {
        this.name = name;
        this.maxOutstandingCount = maxOutstandingCount;
        this.submitBatch = submitBatch;
        Loggable.$init$((Loggable)this);
        this.emptyBatch = new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)package$.MODULE$.Vector().empty());
        this.currentBatch = new AtomicReference<Tuple2<Object, Vector<R>>>(this.emptyBatch);
        this.com$gilt$gfc$concurrent$BatcherImpl$$isRunning = true;
        this.flushTask = new TimerTask(this){
            private final /* synthetic */ BatcherImpl $outer;

            public void run() {
                block0: {
                    if (!this.$outer.com$gilt$gfc$concurrent$BatcherImpl$$isRunning) break block0;
                    this.$outer.flush();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.flushTask, maxOutstandingDuration.toMillis(), maxOutstandingDuration.toMillis());
    }
}

