/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.gfc.concurrent;

import com.gilt.gfc.concurrent.ScalaFutures$Implicits$;
import com.gilt.gfc.concurrent.Timeouts$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.DurationConversions;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class ScalaFutures$ {
    public static ScalaFutures$ MODULE$;
    private final FiniteDuration com$gilt$gfc$concurrent$ScalaFutures$$FiniteDurationMax;
    private final Future<Option<Nothing$>> FutureNone;

    static {
        new ScalaFutures$();
    }

    public FiniteDuration com$gilt$gfc$concurrent$ScalaFutures$$FiniteDurationMax() {
        return this.com$gilt$gfc$concurrent$ScalaFutures$$FiniteDurationMax;
    }

    public <A> Future<A> FutureOps(Future<A> f) {
        return f;
    }

    public <A> A AsFuture(A a) {
        return a;
    }

    public <A> Future<Try<A>> FutureTryOps(Future<Try<A>> f) {
        return f;
    }

    public <A> Future<Future<A>> FutureFutureOps(Future<Future<A>> f) {
        return f;
    }

    public <T> Future<Object> exists(TraversableOnce<Future<T>> futures, Function1<T, Object> predicate, ExecutionContext executor) {
        return futures.isEmpty() ? Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false)) : Future$.MODULE$.find(futures, predicate, executor).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDefined()), executor);
    }

    public <T> Future<Object> forall(TraversableOnce<Future<T>> futures, Function1<T, Object> predicate, ExecutionContext executor) {
        return futures.isEmpty() ? Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true)) : Future$.MODULE$.find(futures, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaFutures$.$anonfun$forall$1(predicate, x$2)), executor).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()), executor);
    }

    public Future<Option<Nothing$>> FutureNone() {
        return this.FutureNone;
    }

    public <T> Future<T> fromTry(Try<T> t) {
        Future future;
        Try<T> try_ = t;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object s = success.value();
            future = Future$.MODULE$.successful(s);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            future = Future$.MODULE$.failed(e);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public <T> Future<T> safely(Function0<Future<T>> f) {
        Future future;
        Try try_ = Try$.MODULE$.apply(f);
        if (try_ instanceof Success) {
            Future s;
            Success success = (Success)try_;
            future = s = (Future)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            future = Future$.MODULE$.failed(e);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public <T, R> Future<R> foldFast(TraversableOnce<Future<T>> futures, R zero, Function2<R, T, R> foldFun, ExecutionContext executor) {
        Future future;
        if (futures.isEmpty()) {
            future = Future$.MODULE$.successful(zero);
        } else {
            AtomicReference atomic = new AtomicReference(zero);
            Promise promise = Promise$.MODULE$.apply();
            AtomicInteger counter = new AtomicInteger();
            futures.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Boolean bl;
                    Try try_ = x0$1;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Object v = success.value();
                        $this.update$1((Function1 & Serializable & scala.Serializable)x$5 -> foldFun$1.apply(x$5, v), atomic$1);
                        bl = counter$1.incrementAndGet() == futures$1.size() ? BoxesRunTime.boxToBoolean((boolean)promise$1.trySuccess(atomic$1.get())) : BoxedUnit.UNIT;
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        bl = BoxesRunTime.boxToBoolean((boolean)promise$1.tryFailure(t));
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return bl;
                }, executor);
                return BoxedUnit.UNIT;
            });
            future = promise.future();
        }
        return future;
    }

    public <A, B, M extends TraversableOnce<Object>> Future<M> traverseSequential(M in, Function1<A, Future<B>> fn, CanBuildFrom<M, B, M> cbf, ExecutionContext executor) {
        return ((Future)in.foldLeft((Object)Future$.MODULE$.successful((Object)cbf.apply(in)), (Function2 & Serializable & scala.Serializable)(fr, a) -> fr.flatMap((Function1 & Serializable & scala.Serializable)r -> ((Future)fn.apply(a)).map((Function1 & Serializable & scala.Serializable)b -> r.$plus$eq(b), executor), executor))).map((Function1 & Serializable & scala.Serializable)x$6 -> (TraversableOnce)x$6.result(), executor);
    }

    public <T> Future<T> retry(long maxRetryTimes, Function0<Future<T>> f, ExecutionContext ec, Function1<Throwable, BoxedUnit> log) {
        return this.safely(f).recoverWith((PartialFunction)new scala.Serializable(maxRetryTimes, f, ec, log){
            public static final long serialVersionUID = 0L;
            private final long maxRetryTimes$1;
            private final Function0 f$1;
            private final ExecutionContext ec$1;
            private final Function1 log$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future<T> future;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    if (this.maxRetryTimes$1 > 0L) {
                        this.log$1.apply((Object)e);
                        future = ScalaFutures$.MODULE$.retry(this.maxRetryTimes$1 - 1L, this.f$1, this.ec$1, (Function1<Throwable, BoxedUnit>)this.log$1);
                        return (B1)future;
                    }
                }
                future = function1.apply(x1);
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty() && this.maxRetryTimes$1 > 0L;
                return bl;
            }
            {
                this.maxRetryTimes$1 = maxRetryTimes$1;
                this.f$1 = f$1;
                this.ec$1 = ec$1;
                this.log$1 = log$1;
            }
        }, ec);
    }

    public <T> long retry$default$1() {
        return Long.MAX_VALUE;
    }

    public <T> Function1<Throwable, BoxedUnit> retry$default$4(long maxRetryTimes, Function0<Future<T>> f) {
        return ScalaFutures$Implicits$.MODULE$.NoLog();
    }

    public <T> Future<T> retryWithExponentialDelay(long maxRetryTimes, Deadline maxRetryTimeout, Duration initialDelay, FiniteDuration maxDelay, double exponentFactor, boolean jitter, Function0<Future<T>> f, ExecutionContext ec, Function1<Throwable, BoxedUnit> log) {
        Predef$.MODULE$.require(exponentFactor >= 1.0);
        return this.safely(f).recoverWith((PartialFunction)new scala.Serializable(maxRetryTimes, maxRetryTimeout, initialDelay, maxDelay, exponentFactor, jitter, f, ec, log){
            public static final long serialVersionUID = 0L;
            private final long maxRetryTimes$2;
            private final Deadline maxRetryTimeout$1;
            private final Duration initialDelay$1;
            private final FiniteDuration maxDelay$1;
            private final double exponentFactor$1;
            private final boolean jitter$1;
            private final Function0 f$2;
            private final ExecutionContext ec$2;
            private final Function1 log$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    if (this.maxRetryTimes$2 > 0L && this.maxRetryTimeout$1.timeLeft().toMillis() > 1L) {
                        FiniteDuration finiteDuration;
                        this.log$2.apply((Object)e);
                        Promise p = Promise$.MODULE$.apply();
                        FiniteDuration delayLimit = this.maxDelay$1.min(this.maxRetryTimeout$1.timeLeft());
                        Duration jitteredDelay = this.jitter$1 ? this.initialDelay$1.$times(Random$.MODULE$.nextDouble()) : this.initialDelay$1;
                        Duration duration = jitteredDelay.min((Duration)delayLimit);
                        FiniteDuration finiteDuration2 = duration instanceof FiniteDuration ? (finiteDuration = (FiniteDuration)duration) : ScalaFutures$.MODULE$.com$gilt$gfc$concurrent$ScalaFutures$$FiniteDurationMax();
                        FiniteDuration delay = finiteDuration2;
                        Timeouts$.MODULE$.scheduledExecutor().schedule(delay, (Function0 & Serializable & scala.Serializable)() -> p.completeWith(ScalaFutures$.MODULE$.retryWithExponentialDelay($this.maxRetryTimes$2 - 1L, $this.maxRetryTimeout$1, $this.initialDelay$1.min((Duration)delayLimit).$times($this.exponentFactor$1), $this.maxDelay$1, $this.exponentFactor$1, $this.jitter$1, $this.f$2, $this.ec$2, (Function1<Throwable, BoxedUnit>)$this.log$2)));
                        object = p.future();
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty() && this.maxRetryTimes$2 > 0L && this.maxRetryTimeout$1.timeLeft().toMillis() > 1L;
                return bl;
            }
            {
                this.maxRetryTimes$2 = maxRetryTimes$2;
                this.maxRetryTimeout$1 = maxRetryTimeout$1;
                this.initialDelay$1 = initialDelay$1;
                this.maxDelay$1 = maxDelay$1;
                this.exponentFactor$1 = exponentFactor$1;
                this.jitter$1 = jitter$1;
                this.f$2 = f$2;
                this.ec$2 = ec$2;
                this.log$2 = log$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.gilt.gfc.concurrent.ScalaFutures$$anonfun$retryWithExponentialDelay$1 scala.concurrent.Promise scala.concurrent.duration.FiniteDuration )}, serializedLambda);
            }
        }, ec);
    }

    public <T> long retryWithExponentialDelay$default$1() {
        return Long.MAX_VALUE;
    }

    public <T> Deadline retryWithExponentialDelay$default$2() {
        return (Deadline)new package.DurationInt(package$.MODULE$.DurationInt(1)).day((Object)package.fromNow$.MODULE$, (DurationConversions.Classifier)DurationConversions.fromNowConvert$.MODULE$);
    }

    public <T> Duration retryWithExponentialDelay$default$3() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).millisecond();
    }

    public <T> FiniteDuration retryWithExponentialDelay$default$4() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).day();
    }

    public <T> double retryWithExponentialDelay$default$5() {
        return 2.0;
    }

    public <T> boolean retryWithExponentialDelay$default$6() {
        return true;
    }

    public <T> Function1<Throwable, BoxedUnit> retryWithExponentialDelay$default$9(long maxRetryTimes, Deadline maxRetryTimeout, Duration initialDelay, FiniteDuration maxDelay, double exponentFactor, boolean jitter, Function0<Future<T>> f) {
        return ScalaFutures$Implicits$.MODULE$.NoLog();
    }

    public static final /* synthetic */ boolean $anonfun$forall$1(Function1 predicate$1, Object x$2) {
        return !BoxesRunTime.unboxToBoolean((Object)predicate$1.apply(x$2));
    }

    private final Object update$1(Function1 f, AtomicReference atomic$1) {
        Object newValue;
        Object oldValue;
        while (!atomic$1.compareAndSet(oldValue = atomic$1.get(), newValue = f.apply(oldValue))) {
        }
        return newValue;
    }

    private ScalaFutures$() {
        MODULE$ = this;
        this.com$gilt$gfc$concurrent$ScalaFutures$$FiniteDurationMax = FiniteDuration$.MODULE$.apply(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        this.FutureNone = Future$.MODULE$.successful((Object)None$.MODULE$);
    }
}

