/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.gfc.id;

import com.gilt.gfc.id.Guid;
import java.util.UUID;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;

public final class Guid$
implements Serializable {
    public static Guid$ MODULE$;
    private final int com$gilt$gfc$id$Guid$$UUID_BYTE_LENGTH;
    private final int com$gilt$gfc$id$Guid$$UUID_STRING_LENGTH;
    private final char[] com$gilt$gfc$id$Guid$$DIGITS;

    static {
        new Guid$();
    }

    public int com$gilt$gfc$id$Guid$$UUID_BYTE_LENGTH() {
        return this.com$gilt$gfc$id$Guid$$UUID_BYTE_LENGTH;
    }

    public int com$gilt$gfc$id$Guid$$UUID_STRING_LENGTH() {
        return this.com$gilt$gfc$id$Guid$$UUID_STRING_LENGTH;
    }

    public char[] com$gilt$gfc$id$Guid$$DIGITS() {
        return this.com$gilt$gfc$id$Guid$$DIGITS;
    }

    public <A> Guid<A> apply(UUID uuid) {
        Predef$.MODULE$.require(uuid != null, (Function0 & java.io.Serializable & Serializable)() -> "uuid must not be null");
        return new Guid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public <A> Guid<A> apply(long msb, long lsb) {
        return new Guid(msb, lsb);
    }

    public <A> Guid<A> apply(String data) {
        Tuple2<Object, Object> bits = this.parse(data);
        return this.apply(bits._1$mcJ$sp(), bits._2$mcJ$sp());
    }

    public Tuple2<Object, Object> parse(String data) {
        Predef$.MODULE$.require(data != null, (Function0 & java.io.Serializable & Serializable)() -> "uuid must not be null");
        Predef$.MODULE$.require(data.length() == this.com$gilt$gfc$id$Guid$$UUID_STRING_LENGTH(), (Function0 & java.io.Serializable & Serializable)() -> "uuid data must be 36 characters");
        long msb = this.parseHexLong(data, 0, 8);
        this.assertEquals(data, 8, '-');
        msb <<= 16;
        msb |= this.parseHexLong(data, 9, 4);
        this.assertEquals(data, 13, '-');
        msb <<= 16;
        this.assertEquals(data, 18, '-');
        long lsb = this.parseHexLong(data, 19, 4);
        lsb <<= 48;
        this.assertEquals(data, 23, '-');
        return new Tuple2.mcJJ.sp(msb |= this.parseHexLong(data, 14, 4), lsb |= this.parseHexLong(data, 24, 12));
    }

    public <A> Guid<A> apply(byte[] data) {
        Predef$.MODULE$.require(data != null, (Function0 & java.io.Serializable & Serializable)() -> "uuid must not be null");
        Predef$.MODULE$.require(data.length == this.com$gilt$gfc$id$Guid$$UUID_BYTE_LENGTH(), (Function0 & java.io.Serializable & Serializable)() -> "uuid data must be 16 bytes");
        long msb = this.bytesToLong(data, 0);
        long lsb = this.bytesToLong(data, 8);
        return this.apply(msb, lsb);
    }

    public <T> Guid<T> randomGuid() {
        return this.apply(UUID.randomUUID());
    }

    private final long bytesToLong(byte[] buf, int offset) {
        return (long)(buf[offset + 7] & 0xFF) | (long)(buf[offset + 6] & 0xFF) << 8 | (long)(buf[offset + 5] & 0xFF) << 16 | (long)(buf[offset + 4] & 0xFF) << 24 | (long)(buf[offset + 3] & 0xFF) << 32 | (long)(buf[offset + 2] & 0xFF) << 40 | (long)(buf[offset + 1] & 0xFF) << 48 | (long)(buf[offset] & 0xFF) << 56;
    }

    private void assertEquals(String data, int offset, char expected) {
        if (data.charAt(offset) != expected) {
            throw new IllegalArgumentException("Invalid character at offset " + offset + ": " + data);
        }
    }

    private long parseHexLong(CharSequence data, int startIndex, int len) {
        int radix = 16;
        int endIndex = startIndex + len;
        int digit = this.hexToDigit(data.charAt(startIndex));
        long result = -digit;
        for (int i = startIndex + 1; i < endIndex; ++i) {
            digit = this.hexToDigit(data.charAt(i));
            result = result * (long)radix - (long)digit;
        }
        return -result;
    }

    private int hexToDigit(char c) {
        int n;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'A' && c <= 'F') {
            n = c - 55;
        } else if (c >= 'a' && c <= 'f') {
            n = c - 87;
        } else {
            throw new IllegalArgumentException("Invalid hexadecimal code: " + c);
        }
        return n;
    }

    public final void com$gilt$gfc$id$Guid$$appendHexDigits(StringBuilder strBuf, char[] charBuf, long num, int digits) {
        long hi = 1L << digits * 4;
        long bitmasked = num & hi - 1L;
        int charPos = this.toHexString(charBuf, hi | bitmasked);
        strBuf.append(charBuf, charPos + 1, 63 - charPos);
    }

    private final int toHexString(char[] charBuf, long num) {
        long i = num;
        int charPos = 64;
        do {
            charBuf[--charPos] = this.com$gilt$gfc$id$Guid$$DIGITS()[(int)(i & 0xFL)];
        } while ((i >>>= 4) != 0L);
        return charPos;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Guid$() {
        MODULE$ = this;
        this.com$gilt$gfc$id$Guid$$UUID_BYTE_LENGTH = 16;
        this.com$gilt$gfc$id$Guid$$UUID_STRING_LENGTH = 36;
        this.com$gilt$gfc$id$Guid$$DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

