/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.gfc.kinesis.consumer;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.gilt.gfc.kinesis.consumer.KinesisConsumerConfig;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public abstract class KinesisConsumerConfig$class {
    public static Option kinesisEndpoint(KinesisConsumerConfig $this) {
        return None$.MODULE$;
    }

    public static Option dynamoOverrideAwsCredentialsProvider(KinesisConsumerConfig $this) {
        return None$.MODULE$;
    }

    public static String workerId(KinesisConsumerConfig $this) {
        return UUID.randomUUID().toString();
    }

    public static FiniteDuration leaseFailoverTime(KinesisConsumerConfig $this) {
        return new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    }

    public static FiniteDuration parentShardPollInterval(KinesisConsumerConfig $this) {
        return new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds();
    }

    public static FiniteDuration idleTimeBetweenReads(KinesisConsumerConfig $this) {
        return new package.DurationInt(package$.MODULE$.DurationInt(10)).second();
    }

    public static FiniteDuration shardSyncInterval(KinesisConsumerConfig $this) {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).minute();
    }

    public static FiniteDuration taskBackoffTime(KinesisConsumerConfig $this) {
        return new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds();
    }

    public static FiniteDuration metricsBufferTime(KinesisConsumerConfig $this) {
        return new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds();
    }

    public static int metricsMaxQueueSize(KinesisConsumerConfig $this) {
        return 1000;
    }

    public static int maxBatchSize(KinesisConsumerConfig $this) {
        return 1000;
    }

    public static InitialPositionInStream initialPositionInStream(KinesisConsumerConfig $this) {
        return InitialPositionInStream.TRIM_HORIZON;
    }

    public static FiniteDuration checkpointFailBackoff(KinesisConsumerConfig $this) {
        return new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    }

    public static int checkpointFailRetryCount(KinesisConsumerConfig $this) {
        return 3;
    }

    public static boolean processAllEmptyBatches(KinesisConsumerConfig $this) {
        return false;
    }

    public static final KinesisClientLibConfiguration createStreamConfiguration(KinesisConsumerConfig $this, String streamName) {
        String wid = $this.workerId();
        String aname = $this.appName();
        $this.info((Function0)new Serializable($this, wid, aname, streamName){
            public static final long serialVersionUID = 0L;
            private final String wid$1;
            private final String aname$1;
            private final String streamName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application ", " creating a stream configuration for ", ", with workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.aname$1, this.streamName$1, this.wid$1}));
            }
            {
                this.wid$1 = wid$1;
                this.aname$1 = aname$1;
                this.streamName$1 = streamName$1;
            }
        });
        KinesisClientLibConfiguration baseConfig = new KinesisClientLibConfiguration(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aname, streamName})), streamName, $this.awsCredentialsProvider(), (AWSCredentialsProvider)$this.dynamoOverrideAwsCredentialsProvider().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisConsumerConfig $outer;

            public final AWSCredentialsProvider apply() {
                return this.$outer.awsCredentialsProvider();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), $this.awsCredentialsProvider(), wid).withRegionName($this.regionName()).withFailoverTimeMillis($this.leaseFailoverTime().toMillis()).withMaxRecords($this.maxBatchSize()).withInitialPositionInStream($this.initialPositionInStream()).withIdleTimeBetweenReadsInMillis($this.idleTimeBetweenReads().toMillis()).withCallProcessRecordsEvenForEmptyRecordList(true).withCleanupLeasesUponShardCompletion(false).withParentShardPollIntervalMillis($this.parentShardPollInterval().toMillis()).withShardSyncIntervalMillis($this.shardSyncInterval().toMillis()).withTaskBackoffTimeMillis($this.taskBackoffTime().toMillis()).withMetricsBufferTimeMillis($this.metricsBufferTime().toMillis()).withMetricsMaxQueueSize($this.metricsMaxQueueSize());
        KinesisClientLibConfiguration endpointConfigured = (KinesisClientLibConfiguration)$this.kinesisEndpoint().fold((Function0)new Serializable($this, baseConfig){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration baseConfig$1;

            public final KinesisClientLibConfiguration apply() {
                return this.baseConfig$1;
            }
            {
                this.baseConfig$1 = baseConfig$1;
            }
        }, (Function1)new Serializable($this, baseConfig){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration baseConfig$1;

            public final KinesisClientLibConfiguration apply(String x$1) {
                return this.baseConfig$1.withKinesisEndpoint(x$1);
            }
            {
                this.baseConfig$1 = baseConfig$1;
            }
        });
        KinesisClientLibConfiguration fullConfig = (KinesisClientLibConfiguration)$this.awsClientConfig().fold((Function0)new Serializable($this, endpointConfigured){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration endpointConfigured$1;

            public final KinesisClientLibConfiguration apply() {
                return this.endpointConfigured$1;
            }
            {
                this.endpointConfigured$1 = endpointConfigured$1;
            }
        }, (Function1)new Serializable($this, endpointConfigured){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration endpointConfigured$1;

            public final KinesisClientLibConfiguration apply(ClientConfiguration x$1) {
                return this.endpointConfigured$1.withCommonClientConfig(x$1);
            }
            {
                this.endpointConfigured$1 = endpointConfigured$1;
            }
        });
        return fullConfig;
    }

    public static void $init$(KinesisConsumerConfig $this) {
    }
}

