/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.gfc.util;

import com.gilt.gfc.util.Retry;
import java.io.Serializable;
import java.util.concurrent.locks.LockSupport;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.DurationConversions;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static Retry$ MODULE$;

    static {
        new Retry$();
    }

    public <I, O> O retryFold(long maxRetryTimes, I i, Function1<I, Either<I, O>> f, Function1<Throwable, BoxedUnit> log) {
        Object o;
        Either either;
        while (true) {
            Either either2;
            boolean bl = false;
            Left left = null;
            try {
                either2 = (Either)f.apply(i);
            }
            catch (Exception e) {
                if (maxRetryTimes <= 0L) {
                    throw new Retry.TooManyRetries<I>(i, (Option<Exception>)new Some((Object)e));
                }
                log.apply((Object)e);
                either2 = either = package$.MODULE$.Left().apply(i);
            }
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Object i1 = left.value();
                if (maxRetryTimes <= 0L) {
                    throw new Retry.TooManyRetries<Object>(i1, (Option<Exception>)None$.MODULE$);
                }
            }
            if (!bl) break;
            Object i1 = left.value();
            i = i1;
            --maxRetryTimes;
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Object object = o = right.value();
        return (O)object;
    }

    public <T> T retry(long maxRetryTimes, Function0<T> f, Function1<Throwable, BoxedUnit> log) {
        Object o;
        try {
            o = this.retryFold(maxRetryTimes, BoxedUnit.UNIT, (Function1 & Serializable & scala.Serializable)x$3 -> package$.MODULE$.Right().apply(f.apply()), log);
        }
        catch (Throwable throwable) {
            Retry.TooManyRetries tooManyRetries;
            Option<Exception> option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Retry.TooManyRetries && (option = (tooManyRetries = (Retry.TooManyRetries)throwable2).wrapped()) instanceof Some) {
                Some some = (Some)option;
                Exception e = (Exception)some.value();
                throw e;
            }
            throw throwable;
        }
        return (T)o;
    }

    public <I, O> long retryFold$default$1() {
        return Long.MAX_VALUE;
    }

    public <I, O> Function1<Throwable, BoxedUnit> retryFold$default$4(long maxRetryTimes, I i, Function1<I, Either<I, O>> f) {
        return (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.printStackTrace();
            return BoxedUnit.UNIT;
        };
    }

    public <T> long retry$default$1() {
        return Long.MAX_VALUE;
    }

    public <T> Function1<Throwable, BoxedUnit> retry$default$3(long maxRetryTimes, Function0<T> f) {
        return (Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.printStackTrace();
            return BoxedUnit.UNIT;
        };
    }

    public <I, O> O retryFoldWithExponentialDelay(long maxRetryTimes, Deadline maxRetryTimeout, Duration initialDelay, FiniteDuration maxDelay, double exponentFactor, I i, Function1<I, Either<I, O>> f, Function1<Throwable, BoxedUnit> log) {
        Object o;
        Either either;
        while (true) {
            Either either2;
            Predef$.MODULE$.require(exponentFactor >= 1.0);
            Duration delay = (Duration)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Duration[]{initialDelay, maxDelay, maxRetryTimeout.timeLeft()}))).min((Ordering)Duration.DurationIsOrdered$.MODULE$);
            boolean bl = false;
            Left left = null;
            try {
                either2 = (Either)f.apply(i);
            }
            catch (Exception e) {
                if (maxRetryTimes <= 0L || maxRetryTimeout.isOverdue()) {
                    throw new Retry.TooManyRetries<I>(i, (Option<Exception>)new Some((Object)e));
                }
                log.apply((Object)e);
                long delayNs = delay.toNanos();
                if (delayNs < 10000000L) {
                    LockSupport.parkNanos(delayNs);
                } else {
                    try {
                        Thread.sleep(delayNs / 1000000L, (int)(delayNs % 1000000L));
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                either2 = either = package$.MODULE$.Left().apply(i);
            }
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Object i1 = left.value();
                if (maxRetryTimes <= 0L) {
                    throw new Retry.TooManyRetries<Object>(i1, (Option<Exception>)None$.MODULE$);
                }
            }
            if (!bl) break;
            Object i1 = left.value();
            Duration duration = delay.$times(exponentFactor);
            i = i1;
            initialDelay = duration;
            --maxRetryTimes;
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Object object = o = right.value();
        return (O)object;
    }

    public <I, O> long retryFoldWithExponentialDelay$default$1() {
        return Long.MAX_VALUE;
    }

    public <I, O> Deadline retryFoldWithExponentialDelay$default$2() {
        return (Deadline)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).day((Object)package.fromNow$.MODULE$, (DurationConversions.Classifier)DurationConversions.fromNowConvert$.MODULE$);
    }

    public <I, O> Duration retryFoldWithExponentialDelay$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millisecond();
    }

    public <I, O> FiniteDuration retryFoldWithExponentialDelay$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).day();
    }

    public <I, O> double retryFoldWithExponentialDelay$default$5() {
        return 2.0;
    }

    public <I, O> Function1<Throwable, BoxedUnit> retryFoldWithExponentialDelay$default$8(long maxRetryTimes, Deadline maxRetryTimeout, Duration initialDelay, FiniteDuration maxDelay, double exponentFactor, I i, Function1<I, Either<I, O>> f) {
        return (Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.printStackTrace();
            return BoxedUnit.UNIT;
        };
    }

    public <T> T retryWithExponentialDelay(long maxRetryTimes, Deadline maxRetryTimeout, Duration initialDelay, FiniteDuration maxDelay, double exponentFactor, Function0<T> f, Function1<Throwable, BoxedUnit> log) {
        Object o;
        try {
            o = this.retryFoldWithExponentialDelay(maxRetryTimes, maxRetryTimeout, initialDelay, maxDelay, exponentFactor, BoxedUnit.UNIT, (Function1 & Serializable & scala.Serializable)x$6 -> package$.MODULE$.Right().apply(f.apply()), log);
        }
        catch (Throwable throwable) {
            Retry.TooManyRetries tooManyRetries;
            Option<Exception> option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Retry.TooManyRetries && (option = (tooManyRetries = (Retry.TooManyRetries)throwable2).wrapped()) instanceof Some) {
                Some some = (Some)option;
                Exception e = (Exception)some.value();
                throw e;
            }
            throw throwable;
        }
        return (T)o;
    }

    public <T> long retryWithExponentialDelay$default$1() {
        return Long.MAX_VALUE;
    }

    public <T> Deadline retryWithExponentialDelay$default$2() {
        return (Deadline)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).day((Object)package.fromNow$.MODULE$, (DurationConversions.Classifier)DurationConversions.fromNowConvert$.MODULE$);
    }

    public <T> Duration retryWithExponentialDelay$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millisecond();
    }

    public <T> FiniteDuration retryWithExponentialDelay$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).day();
    }

    public <T> double retryWithExponentialDelay$default$5() {
        return 2.0;
    }

    public <T> Function1<Throwable, BoxedUnit> retryWithExponentialDelay$default$7(long maxRetryTimes, Deadline maxRetryTimeout, Duration initialDelay, FiniteDuration maxDelay, double exponentFactor, Function0<T> f) {
        return (Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.printStackTrace();
            return BoxedUnit.UNIT;
        };
    }

    private Retry$() {
        MODULE$ = this;
    }
}

