/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.util.net.dns;

import com.gilt.util.net.TransportProtocol;
import com.gilt.util.net.dns.ServiceName;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u000153Q!\u0001\u0002\u0001\u00051\u0011\u0001b\u0015:w#V,'/\u001f\u0006\u0003\u0007\u0011\t1\u0001\u001a8t\u0015\t)a!A\u0002oKRT!a\u0002\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0013)\tAaZ5mi*\t1\"A\u0002d_6\u001c2\u0001A\u0007\u0016!\tq1#D\u0001\u0010\u0015\t\u0001\u0012#\u0001\u0003mC:<'\"\u0001\n\u0002\t)\fg/Y\u0005\u0003)=\u0011aa\u00142kK\u000e$\bC\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"aC*dC2\fwJ\u00196fGRD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\fg\u0016\u0014h/[2f\u001d\u0006lWm\u0001\u0001\u0011\u0005}\u0001S\"\u0001\u0002\n\u0005\u0005\u0012!aC*feZL7-\u001a(b[\u0016D\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0012iJ\fgn\u001d9peR\u0004&o\u001c;pG>d\u0007CA\u0013'\u001b\u0005!\u0011BA\u0014\u0005\u0005E!&/\u00198ta>\u0014H\u000f\u0015:pi>\u001cw\u000e\u001c\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005iA-\u001a4bk2$Hi\\7bS:\u00042AF\u0016.\u0013\tasC\u0001\u0004PaRLwN\u001c\t\u0003]Er!AF\u0018\n\u0005A:\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\f\t\u000bU\u0002A\u0011\u0001\u001c\u0002\rqJg.\u001b;?)\u00119\u0004(\u000f\u001e\u0011\u0005}\u0001\u0001\"\u0002\u000f5\u0001\u0004q\u0002\"B\u00125\u0001\u0004!\u0003\"B\u00155\u0001\u0004Q\u0003\"\u0002\u001f\u0001\t\u0003i\u0014!B9vKJLX#A\u0017\t\r}\u0002\u0001\u0015\"\u0003A\u0003I!WMZ1vYR$u.\\1j]B\u000b'\u000f^:\u0016\u0003\u0005\u00032A\u0011&.\u001d\t\u0019\u0005J\u0004\u0002E\u000f6\tQI\u0003\u0002G;\u00051AH]8pizJ\u0011\u0001G\u0005\u0003\u0013^\tq\u0001]1dW\u0006<W-\u0003\u0002L\u0019\n\u00191+Z9\u000b\u0005%;\u0002")
public class SrvQuery
implements ScalaObject {
    private final ServiceName serviceName;
    private final TransportProtocol transportProtocol;
    private final Option<String> defaultDomain;

    public String query() {
        Seq<String> serviceNameParts = this.serviceName.parts();
        Predef$.MODULE$.assert(!serviceNameParts.isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Service name validation failed, empty service name parts";
            }
        });
        String srvService = new StringBuilder().append((Object)"_").append((Object)((String)serviceNameParts.head()).toLowerCase()).toString();
        String srvProto = new StringBuilder().append((Object)"_").append((Object)this.transportProtocol.toString().toLowerCase()).toString();
        String srvName = ((TraversableOnce)((TraversableLike)serviceNameParts.tail()).$plus$plus(this.defaultDomainParts(), Seq$.MODULE$.canBuildFrom())).mkString(".");
        return ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srvService, srvProto, srvName, ""}))).mkString(".");
    }

    private Seq<String> defaultDomainParts() {
        return (Seq)this.defaultDomain.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<String> apply(String string) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(string).split('.')).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public SrvQuery(ServiceName serviceName, TransportProtocol transportProtocol, Option<String> defaultDomain) {
        this.serviceName = serviceName;
        this.transportProtocol = transportProtocol;
        this.defaultDomain = defaultDomain;
        Predef$.MODULE$.require(serviceName != null, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "serviceName must not be null";
            }
        });
        Predef$.MODULE$.require(transportProtocol != null, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "transportProtocol must not be null";
            }
        });
        Predef$.MODULE$.require(defaultDomain != null, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "defaultDomain must not be null";
            }
        });
    }
}

