/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.util.net.dns;

import com.gilt.util.net.TransportProtocol;
import com.gilt.util.net.dns.ServiceLookup;
import com.gilt.util.net.dns.ServiceLookup$class;
import com.gilt.util.net.dns.ServiceLookupException;
import com.gilt.util.net.dns.ServiceName;
import com.gilt.util.net.dns.ServiceRecord;
import com.gilt.util.net.dns.SrvQuery;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLookup$
implements ServiceLookup,
ScalaObject {
    public static final ServiceLookup$ MODULE$;
    private final Logger log;
    private final List<String> DnsSearchPaths;

    static {
        new ServiceLookup$();
    }

    @Override
    public TransportProtocol lookup$default$2() {
        return ServiceLookup$class.lookup$default$2(this);
    }

    @Override
    public Seq<ServiceRecord> lookup(String nameStr, TransportProtocol transportProtocol) {
        ServiceName serviceName = new ServiceName(nameStr);
        Seq exceptionResult1 = null;
        try {
            Seq seq;
            if (serviceName.isAbsolute()) {
                seq = this.runQuery(new SrvQuery(serviceName, transportProtocol, (Option<String>)None$.MODULE$).query());
            } else if (this.DnsSearchPaths.isEmpty()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("Expected to find default DNS search path(s) in resolv.conf but none are defined");
                }
                seq = (Seq)Seq$.MODULE$.empty();
            } else {
                seq = this.lookup(serviceName, transportProtocol, this.DnsSearchPaths);
            }
            exceptionResult1 = seq;
            return exceptionResult1;
        }
        catch (Exception exception) {
            throw new ServiceLookupException(nameStr, exception);
        }
    }

    private Seq<ServiceRecord> lookup(ServiceName serviceName, TransportProtocol transportProtocol, List<String> dnsSearchPaths) {
        List list;
        block6: {
            Seq<ServiceRecord> seq;
            block5: {
                while ((list = dnsSearchPaths) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    String string = (String)colon2.hd$1();
                    String sp = string;
                    Seq<ServiceRecord> records = this.runQuery(new SrvQuery(serviceName, transportProtocol, (Option<String>)new Some((Object)sp)).query());
                    if (records.isEmpty()) {
                        dnsSearchPaths = colon2.tl$1();
                        continue;
                    }
                    seq = records;
                    break block5;
                }
                Nil$ nil$ = Nil$.MODULE$;
                List list2 = list;
                if (nil$ != null ? !nil$.equals(list2) : list2 != null) break block6;
                seq = (Seq<ServiceRecord>)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(list);
    }

    private Seq<ServiceRecord> runQuery(String what) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(new StringBuilder().append((Object)"looking up ").append((Object)what).toString());
        }
        Lookup l = new Lookup(what, 33, 1);
        l.run();
        return l.getResult() == 0 ? (Seq)((TraversableLike)Option$.MODULE$.apply((Object)Predef$.MODULE$.refArrayOps((Object[])l.getAnswers()).toSeq()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ServiceRecord apply(Record record) {
                return ServiceLookup$.MODULE$.com$gilt$util$net$dns$ServiceLookup$$toServiceRecord(record);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
    }

    public final ServiceRecord com$gilt$util$net$dns$ServiceLookup$$toServiceRecord(Record r) {
        SRVRecord srvR = (SRVRecord)r;
        return new ServiceRecord(InetAddress.getByName(srvR.getTarget().toString()), srvR.getPort(), srvR.getPriority(), srvR.getWeight());
    }

    private List<String> getDnsSearchPaths() {
        List systemSearchPaths = (List)Option$.MODULE$.apply((Object)Predef$.MODULE$.refArrayOps((Object[])Lookup.getDefaultSearchPath()).toList()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        return (List)systemSearchPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Name name) {
                return name.toString();
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private ServiceLookup$() {
        MODULE$ = this;
        ServiceLookup$class.$init$(this);
        this.log = LoggerFactory.getLogger((String)this.getClass().getName());
        this.DnsSearchPaths = this.getDnsSearchPaths();
        this.log.info(new StringBuilder().append((Object)"started with DNS search paths ").append(this.DnsSearchPaths).toString());
    }
}

