/*
 * Decompiled with CFR 0.152.
 */
package com.ginsberg.junit.exit;

import com.ginsberg.junit.exit.DisallowExitSecurityManager;
import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import com.ginsberg.junit.exit.SystemExitPreventedException;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;

public class SystemExitExtension
implements BeforeEachCallback,
AfterEachCallback,
TestExecutionExceptionHandler {
    private Integer expectedStatusCode;
    private final DisallowExitSecurityManager disallowExitSecurityManager = new DisallowExitSecurityManager(System.getSecurityManager());
    private SecurityManager originalSecurityManager;

    public void afterEach(ExtensionContext context) {
        System.setSecurityManager(this.originalSecurityManager);
        if (this.expectedStatusCode == null) {
            Assertions.assertNotNull((Object)this.disallowExitSecurityManager.getFirstExitStatusCode(), (String)"Expected System.exit() to be called, but it was not");
        } else {
            Assertions.assertEquals((Object)this.expectedStatusCode, (Object)this.disallowExitSecurityManager.getFirstExitStatusCode(), (String)("Expected System.exit(" + this.expectedStatusCode + ") to be called, but it was not."));
        }
    }

    public void beforeEach(ExtensionContext context) {
        this.originalSecurityManager = System.getSecurityManager();
        this.getAnnotation(context).ifPresent(code -> {
            this.expectedStatusCode = code.value();
        });
        System.setSecurityManager(this.disallowExitSecurityManager);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (!(throwable instanceof SystemExitPreventedException)) {
            throw throwable;
        }
    }

    private Optional<ExpectSystemExitWithStatus> getAnnotation(ExtensionContext context) {
        Optional method = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), ExpectSystemExitWithStatus.class);
        if (method.isPresent()) {
            return method;
        }
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), ExpectSystemExitWithStatus.class);
    }
}

