/*
 * Decompiled with CFR 0.152.
 */
package com.ginsberg.junit.exit;

import com.ginsberg.junit.exit.DisallowExitSecurityManager;
import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import com.ginsberg.junit.exit.FailOnSystemExit;
import com.ginsberg.junit.exit.SystemExitPreventedException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;

public class SystemExitExtension
implements BeforeEachCallback,
AfterEachCallback,
TestExecutionExceptionHandler {
    private Integer expectedStatusCode;
    private boolean failOnSystemExit;
    private final DisallowExitSecurityManager disallowExitSecurityManager = new DisallowExitSecurityManager(System.getSecurityManager());
    private SecurityManager originalSecurityManager;

    public void afterEach(ExtensionContext context) {
        System.setSecurityManager(this.originalSecurityManager);
        if (this.disallowExitSecurityManager.getFirstExitStatusCode() != null && this.failOnSystemExit) {
            Assertions.fail((String)("Unexpected System.exit() with status code '" + this.disallowExitSecurityManager.getFirstExitStatusCode() + "' caught"));
        } else if (this.expectedStatusCode == null) {
            Assertions.assertNotNull((Object)this.disallowExitSecurityManager.getFirstExitStatusCode(), (String)"Expected System.exit() to be called, but it was not");
        } else {
            Assertions.assertEquals((Integer)this.expectedStatusCode, (Integer)this.disallowExitSecurityManager.getFirstExitStatusCode(), (String)("Expected System.exit(" + this.expectedStatusCode + ") to be called, but it was not."));
        }
    }

    public void beforeEach(ExtensionContext context) {
        this.originalSecurityManager = System.getSecurityManager();
        this.failOnSystemExit = this.getAnnotation(context, FailOnSystemExit.class).isPresent();
        this.getAnnotation(context, ExpectSystemExitWithStatus.class).ifPresent(code -> {
            this.expectedStatusCode = code.value();
        });
        System.setSecurityManager(this.disallowExitSecurityManager);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (!(throwable instanceof SystemExitPreventedException)) {
            throw throwable;
        }
    }

    private <T extends Annotation> Optional<T> getAnnotation(ExtensionContext context, Class<T> annotationClass) {
        Optional method = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), annotationClass);
        if (method.isPresent()) {
            return method;
        }
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), annotationClass);
    }
}

