/*
 * Decompiled with CFR 0.152.
 */
package com.ginsberg.junit.exit.assertions;

import com.ginsberg.junit.exit.SystemExitPreventedException;
import com.ginsberg.junit.exit.agent.AgentSystemExitHandlerStrategy;
import org.junit.jupiter.api.Assertions;

public class SystemExitAssertion {
    private final SystemExitPreventedException theException;

    public SystemExitAssertion(SystemExitPreventedException theException) {
        this.theException = theException;
    }

    public static SystemExitAssertion assertThatCallsSystemExit(Runnable function) {
        return new SystemExitAssertion(SystemExitAssertion.catchSystemExitFrom(function)).calledSystemExit();
    }

    public static void assertThatDoesNotCallSystemExit(Runnable function) {
        new SystemExitAssertion(SystemExitAssertion.catchSystemExitFrom(function)).didNotCallSystemExit();
    }

    private SystemExitAssertion calledSystemExit() {
        if (this.theException == null) {
            Assertions.fail((String)"Expected call to System.exit() did not happen");
        }
        return this;
    }

    private SystemExitAssertion didNotCallSystemExit() {
        if (this.theException != null) {
            Assertions.fail((String)("Unexpected call to System.exit() with exit code " + this.theException.getStatusCode()), (Throwable)this.theException);
        }
        return this;
    }

    private static SystemExitPreventedException catchSystemExitFrom(Runnable function) {
        AgentSystemExitHandlerStrategy exitPreventerStrategy = new AgentSystemExitHandlerStrategy();
        try {
            exitPreventerStrategy.beforeTest();
            function.run();
        }
        catch (SystemExitPreventedException e) {
            SystemExitPreventedException systemExitPreventedException = e;
            return systemExitPreventedException;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            exitPreventerStrategy.afterTest();
        }
        return null;
    }

    public SystemExitAssertion withExitCode(int code) {
        Assertions.assertEquals((int)code, (int)this.theException.getStatusCode(), (String)"Wrong exit code found");
        return this;
    }

    public SystemExitAssertion withExitCodeInRange(int startInclusive, int endInclusive) {
        Assertions.assertTrue((startInclusive < endInclusive ? 1 : 0) != 0, (String)"Start must come before end");
        int code = this.theException.getStatusCode();
        Assertions.assertTrue((startInclusive <= code && code <= endInclusive ? 1 : 0) != 0, (String)("Exit code expected in range (" + startInclusive + " .. " + endInclusive + ") but was " + code));
        return this;
    }
}

