/*
 * Decompiled with CFR 0.152.
 */
package com.ginsberg.junit.exit.agent;

import com.ginsberg.junit.exit.ExitPreventerStrategy;
import com.ginsberg.junit.exit.SystemExitPreventedException;
import com.ginsberg.junit.exit.agent.DoNotRewriteExitCalls;

@DoNotRewriteExitCalls
public class AgentSystemExitHandlerStrategy
implements ExitPreventerStrategy {
    private static Integer firstExitStatusCode;
    private static boolean loadedFromAgent;
    private static boolean isRunningTest;

    public static void handleExit(int status) {
        if (isRunningTest) {
            if (firstExitStatusCode == null) {
                firstExitStatusCode = status;
            }
            throw new SystemExitPreventedException(firstExitStatusCode);
        }
        System.exit(status);
    }

    public static void agentInit() {
        loadedFromAgent = true;
    }

    public static boolean isLoadedFromAgent() {
        return loadedFromAgent;
    }

    @Override
    public Integer firstExitStatusCode() {
        return firstExitStatusCode;
    }

    @Override
    public void beforeTest() {
        isRunningTest = true;
    }

    @Override
    public void afterTest() {
        isRunningTest = false;
    }

    @Override
    public void resetBetweenTests() {
        firstExitStatusCode = null;
    }

    static {
        loadedFromAgent = false;
        isRunningTest = false;
    }
}

