/*
 * Decompiled with CFR 0.152.
 */
package com.giovds;

import com.giovds.DependenciesToQueryMapper;
import com.giovds.QueryClient;
import com.giovds.dto.DependencyResponse;
import java.time.LocalDate;
import java.time.Period;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="average", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class AverageAgeMojo
extends AbstractMojo {
    private QueryClient client = new QueryClient();
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;
    private final LocalDate today = LocalDate.now();

    public AverageAgeMojo() {
    }

    public void execute() throws MojoExecutionException {
        Set<Dependency> dependenciesToConsider = this.project.getArtifacts().stream().peek(artifact -> this.info("Found artifact %s", artifact.getId())).filter(this::isCompileTimeDependency).peek(artifact -> this.info("Found compile-time artifact %s", artifact.getId())).filter(this::isDependencyOutsideProject).peek(artifact -> this.info("Found compile-time artifact outside this project %s", artifact.getId())).map(this::convertToDependency).collect(Collectors.toSet());
        if (dependenciesToConsider.isEmpty()) {
            this.info("No dependencies found", new Object[0]);
            return;
        }
        List<String> queries = DependenciesToQueryMapper.mapToQueries(dependenciesToConsider);
        this.debug("Queries: %s", queries);
        Set<DependencyResponse> results = this.client.search(queries);
        this.debug("Results: %s", results);
        LongSummaryStatistics stats = results.stream().sorted(Comparator.comparing(DependencyResponse::id)).mapToLong(dependency -> {
            long ageInDays = this.calculateDependencyAge((DependencyResponse)dependency);
            this.info("Dependency %s is %d days old", dependency.id(), ageInDays);
            return ageInDays;
        }).summaryStatistics();
        this.info("Found %d dependencies", stats.getCount());
        this.info("Total age: %d days", stats.getSum());
        this.info("Average age: %d days", (int)stats.getAverage());
    }

    private Dependency convertToDependency(Artifact artifact) {
        Dependency result = new Dependency();
        result.setGroupId(artifact.getGroupId());
        result.setArtifactId(artifact.getArtifactId());
        result.setVersion(artifact.getVersion());
        result.setClassifier(artifact.getClassifier());
        result.setType(artifact.getType());
        return result;
    }

    private long calculateDependencyAge(DependencyResponse dependency) {
        Period between = Period.between(DependencyResponse.getDateTime(dependency.timestamp()), this.today);
        return 365L * (long)between.getYears() + (long)between.getMonths() * 365L / 12L + (long)between.getDays();
    }

    private boolean isCompileTimeDependency(Artifact artifact) {
        return "compile".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "system".equals(artifact.getScope());
    }

    private boolean isDependencyOutsideProject(Artifact artifact) {
        return !this.project.getGroupId().equals(artifact.getGroupId());
    }

    private void debug(String message, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(message, args));
        }
    }

    private void info(String message, Object ... args) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)String.format(message, args));
        }
    }

    AverageAgeMojo(QueryClient client) {
        this.client = client;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }
}

