/*
 * Decompiled with CFR 0.152.
 */
package com.giovds;

import com.giovds.DependenciesToQueryMapper;
import com.giovds.QueryClient;
import com.giovds.dto.DependencyResponse;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresOnline=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class CheckMojo
extends AbstractMojo {
    private QueryClient client = new QueryClient();
    @Parameter(property="shouldFailBuild")
    private boolean shouldFailBuild = false;
    @Parameter(property="years")
    private int years = 1;
    @Parameter(property="includePlugins")
    private boolean includePlugins = false;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public CheckMojo() {
    }

    CheckMojo(QueryClient client) {
        this.client = client;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<Dependency> dependenciesToConsider = new HashSet<Dependency>(this.project.getDependencies());
        if (this.includePlugins) {
            dependenciesToConsider.addAll(CheckMojo.mapArtifactsToDependencies(this.project.getPluginArtifacts()));
        }
        if (dependenciesToConsider.isEmpty()) {
            return;
        }
        List<String> queryForAllDependencies = DependenciesToQueryMapper.mapToQueries(dependenciesToConsider);
        Set<DependencyResponse> result = this.client.search(queryForAllDependencies);
        ArrayList outdatedDependencies = new ArrayList();
        ArrayList outdatedPlugins = new ArrayList();
        for (Dependency currentDependency : dependenciesToConsider) {
            result.stream().filter(dep -> currentDependency.getGroupId().equals(dep.g()) && currentDependency.getArtifactId().equals(dep.a())).filter(dep -> DependencyResponse.getDateTime(dep.timestamp()).isBefore(LocalDate.now().minusYears(this.years))).findAny().ifPresent(dep -> {
                if (dep.isPlugin()) {
                    outdatedPlugins.add(dep);
                } else {
                    outdatedDependencies.add(dep);
                }
            });
        }
        if (!outdatedDependencies.isEmpty()) {
            outdatedDependencies.forEach(this::logWarning);
        }
        if (!outdatedPlugins.isEmpty()) {
            outdatedPlugins.forEach(this::logWarning);
        }
        if (!(!this.shouldFailBuild || outdatedDependencies.isEmpty() && outdatedPlugins.isEmpty())) {
            throw new MojoFailureException("There are dependencies or plugins that are outdated.");
        }
    }

    private static Set<Dependency> mapArtifactsToDependencies(Set<Artifact> artifacts) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        for (Artifact artifact : artifacts) {
            dependencies.add(CheckMojo.mapArtifactToDependency(artifact));
        }
        return dependencies;
    }

    private static Dependency mapArtifactToDependency(Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        return dependency;
    }

    private void logWarning(DependencyResponse dep) {
        String message = String.format("%s '%s' has not received an update since version '%s' was last uploaded '%s'.", dep.isPlugin() ? "Plugin" : "Dependency", dep.id(), dep.v(), DependencyResponse.getDateTime(dep.timestamp()));
        if (this.shouldFailBuild) {
            this.getLog().error((CharSequence)message);
        } else {
            this.getLog().warn((CharSequence)message);
        }
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    void setShouldFailBuild(boolean shouldFailBuild) {
        this.shouldFailBuild = shouldFailBuild;
    }

    void setIncludePlugins(boolean includePlugins) {
        this.includePlugins = includePlugins;
    }
}

