/*
 * Decompiled with CFR 0.152.
 */
package com.giovds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Dependency;

public class DependenciesToQueryMapper {
    private static final int maxItemsPerQuery = 20;
    private static final String JOIN_CHARS = "+OR+";

    private DependenciesToQueryMapper() {
    }

    public static List<String> mapToQueries(Collection<Dependency> dependencies) {
        ArrayList<String> result = new ArrayList<String>();
        int itemsInQuery = 0;
        StringBuilder query = new StringBuilder();
        for (Dependency dependency : dependencies) {
            String nextQueryParam = GroupArtifactIdMapper.toQueryString(dependency);
            query.append(nextQueryParam);
            if (++itemsInQuery == 20) {
                result.add(query.toString());
                itemsInQuery = 0;
                query = new StringBuilder();
                continue;
            }
            query.append(JOIN_CHARS);
        }
        DependenciesToQueryMapper.removeTrailingJoin(query);
        if (!query.isEmpty()) {
            result.add(query.toString());
        }
        return result;
    }

    private static void removeTrailingJoin(StringBuilder query) {
        if (query.length() > JOIN_CHARS.length()) {
            query.setLength(query.length() - JOIN_CHARS.length());
        }
    }

    private static class GroupArtifactIdMapper {
        private GroupArtifactIdMapper() {
        }

        private static String toQueryString(String groupId, String artifactId, String version) {
            return String.format("(g:%s+AND+a:%s+AND+v:%s)", groupId, artifactId, version);
        }

        public static String toQueryString(Dependency dependency) {
            return GroupArtifactIdMapper.toQueryString(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
    }
}

