/*
 * Decompiled with CFR 0.152.
 */
package com.giovds;

import com.fasterxml.jackson.jr.ob.JSON;
import com.giovds.dto.DependencyResponse;
import com.giovds.dto.MavenCentralResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public class QueryClient {
    private final String main_uri;
    private static final HttpClient client = HttpClient.newHttpClient();

    QueryClient(String uri) {
        this.main_uri = uri;
    }

    public QueryClient() {
        this("https://search.maven.org/solrsearch/select");
    }

    public Set<DependencyResponse> search(List<String> queries) throws MojoExecutionException {
        try {
            HashSet<DependencyResponse> allDependencies = new HashSet<DependencyResponse>();
            for (String query : queries) {
                HttpRequest request = this.buildHttpRequest(query);
                allDependencies.addAll((Collection<DependencyResponse>)client.send(request, new SearchResponseBodyHandler()).body());
            }
            return allDependencies;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to connect.", e);
        }
    }

    private HttpRequest buildHttpRequest(String query) {
        String uri = String.format("%s?q=%s&wt=json", this.main_uri, query);
        return HttpRequest.newBuilder().GET().version(HttpClient.Version.HTTP_2).uri(URI.create(uri)).build();
    }

    private static class SearchResponseBodyHandler
    implements HttpResponse.BodyHandler<Set<DependencyResponse>> {
        private SearchResponseBodyHandler() {
        }

        @Override
        public HttpResponse.BodySubscriber<Set<DependencyResponse>> apply(HttpResponse.ResponseInfo responseInfo) {
            if (responseInfo.statusCode() > 201) {
                return HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8), s -> {
                    throw new RuntimeException("Search failed: status: " + responseInfo.statusCode() + " body: " + s);
                });
            }
            HttpResponse.BodySubscriber<InputStream> stream = HttpResponse.BodySubscribers.ofInputStream();
            return HttpResponse.BodySubscribers.mapping(stream, this::toSearchResponse);
        }

        Set<DependencyResponse> toSearchResponse(InputStream inputStream) {
            HashSet<DependencyResponse> hashSet;
            block8: {
                InputStream input = inputStream;
                try {
                    MavenCentralResponse mavenCentralResponse = (MavenCentralResponse)JSON.std.beanFrom(MavenCentralResponse.class, (Object)input);
                    hashSet = new HashSet<DependencyResponse>(mavenCentralResponse.response().docs());
                    if (input == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                input.close();
            }
            return hashSet;
        }
    }
}

