// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: collection.utils.java.vm
// ______________________________________________________
package net.gdface.utils;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import java.util.Objects;

/**
 * @author guyadong
 *
 */
public class CollectionUtils {
    private CollectionUtils() {}
    public static interface Function<F, T> {
        /** 
         * function interface
         * @param input
         * @return output 
         */
        T apply( F input);
    }
    /**
     * dual transform type between L and R<br>
     * {@link #toRight(Object)} L -> R<br>
     * {@link #fromRight(Object)} R -> L
     * @author guyadong
     *
     * @param <L> left type
     * @param <R> right type
     */
    public static interface DualTransformer<L,R>{
        /**
         * cast L to R
         * @param input
         * @return output R
         */
        R toRight(L input);
        /**
         * cast R to L
         * @param input
         * @return output L
         */
        L fromRight(R input);
    }
    public static final <L,R> DualTransformer<L,R> asDualTransformer(final Function<L,R> t1,final Function<R,L>t2){
        checkNotNull(t1);
        checkNotNull(t2);
        return new DualTransformer<L,R>(){
            @Override
            public R toRight(L input) {
                return t1.apply(input);
            }
            @Override
            public L fromRight(R input) {
                return t2.apply(input);
            }
        };
    }
    public static final <L,R> Function<L,R> asToRightTransformer(final DualTransformer<L,R> dual){
        checkNotNull(dual);
        return new Function<L,R>(){
            @Override
            public R apply(L input) {
                return dual.toRight(input);
            }
        };
    }
    public static final <L,R> Function<R,L> asFromRightTransformer(final DualTransformer<L,R> dual){
        checkNotNull(dual);
        return new Function<R,L>(){
            @Override
            public L apply(R input) {
                return dual.fromRight(input);
            }
        };
    }
    /** 
     * Ensures that an object reference passed as a parameter to the calling method is not null. 
     * @return the non-null reference that was validated
     */
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }
    /** 
     * Ensures that an object reference passed as a parameter to the calling method is not null. 
     * @return the non-null reference that was validated
     */
    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }
    /** 
     * Ensures that a collection  reference passed as a parameter to the calling method not exists null element if it's not null.
     * @return the non-null-element reference that was validated
     */
    public static<C extends Collection<?>> C checkNotNullElement(C c){
        if(null != c){
            for(Object e:c){
                checkNotNull(e,"element of collection must not be null");
            }
        }
        return c;
    }
    static <V> V safeGet(Map<?, V> map, Object key) {
        checkNotNull(map);
        try {
            return map.get(key);
        } catch (ClassCastException e) {
            return null;
        } catch (NullPointerException e) {
            return null;
        }
    }
    /** @see #tranformKeys(Map, DualTransformer)*/
    public static final<K1,K2,V>Map<K2,V> tranformKeys(Map<K1,V>fromMap, 
            Function<K1, K2> transformer2, 
            Function<K2, K1> transformer1){
        return tranformKeys(fromMap,asDualTransformer(transformer2,transformer1));
    }
    /**
     * Returns a view of a map where each value is transformed by a function. All
     * other properties of the map, such as iteration order, are left intact. <br>
     * see also com.google.common.collect.Maps#transformEntries(Map, com.google.common.collect.Maps.EntryTransformer)
     * @param fromMap
     * @param transformer
     * @return Map transformed
     */
    public static final<K1,K2,V>Map<K2,V> tranformKeys(Map<K1,V>fromMap, 
            DualTransformer<K1, K2> transformer){
        return new TransformedMap<K1, K2, V>(fromMap,transformer);
    }
    /** @see #transform(Set, DualTransformer)*/
    public static final <E1,E2>Set<E2>transform(Set<E1> fromSet, 
            Function<E1, E2> transformer2, 
            Function<E2, E1> transformer1){
        return transform(fromSet,asDualTransformer(transformer2,transformer1));
    }
    /**
     * Returns a view of a set where each key is transformed by a function. All
     * other properties of the map, such as iteration order, are left intact. <br>
     * see also com.google.common.collect.Maps#transformEntries(Map, com.google.common.collect.Maps.EntryTransformer)
     * @param fromSet
     * @param transformer
     * @return Set transformed
     */
    public static final <E1,E2>Set<E2>transform(Set<E1> fromSet, 
            DualTransformer<E1,E2> transformer){
        return new TransformedSet<E1,E2>(fromSet,transformer);
    }
    
    /**
     * Returns an iterator that applies {@code function} to each element of {@code fromIterator}.<br>
     * see also com.google.common.collect.Iterators#transform(Iterator, com.google.common.base.Function)
     * @param fromIterator
     * @param transformer
     * @return an iterator that applies {@code function} to each element of {@code fromIterator}
     */
    public static <F, T> Iterator<T> transform(final Iterator<F> fromIterator,
            final Function<? super F, ? extends T> transformer) {
        return new TransformedIterator<F, T>(fromIterator,transformer);
    }
    /**
     * 合并两个迭代器的数据为一个{@link Map}<br>
     * 要求两个迭代器的元素个数必须一致，
     * 如果{@code keys}中的元素为{@code null}，
     * 则该元素和{@code values}对应value的会自动被忽略
     * @param keys
     * @param values
     * @return 合并后的{@link Map}
     */
    public static<K,V> Map<K, V> merge(Iterator<K> keys,Iterator<V>values){
        if(keys == null || values == null){
            throw new NullPointerException("keyItor or valueItor is null");
        }
        HashMap<K, V> map = new HashMap<K,V>();
        while(keys.hasNext() && values.hasNext()){
            K key = keys.next();
            if(key != null){
                map.put(key, values.next());
            }
        }
        if(keys.hasNext() || values.hasNext()){
            throw new IllegalArgumentException("mismatch size of keys and values");
        }
        return map;
    }
    /**
     * 合并两个{@link Iterable}的数据为一个{@link Map}<br>
     * 要求两个迭代器的元素个数必须一致
     * 如果{@code keys}中的元素为{@code null}，
     * 则该元素和{@code values}对应value的会自动被忽略
     * @param keys
     * @param values
     * @return 合并后的{@link Map}
     */
    public static<K,V> Map<K, V> merge(Iterable<K> keys,Iterable<V>values){
        if(keys == null || values == null){
            throw new NullPointerException("keys or values is null");
        }
        return merge(keys.iterator(),values.iterator());
    }
    /**
     * 合并两个数组的数据为一个{@link Map}<br>
     * 如果{@code keys}中的元素为{@code null}，
     * 则该元素和{@code values}对应value的会自动被忽略
     * @param keys
     * @param values
     * @return 合并后的{@link Map}
     */
    public static<K,V> Map<K, V> merge(K[] keys,V[]values){
        if(keys == null || values == null){
            throw new NullPointerException("keys or values is null");
        }
        return merge(Arrays.asList(keys),Arrays.asList(values));
    }
    static class TransformedIterator<F, T> implements Iterator<T> {
        final Iterator<? extends F> backingIterator;
        private Function<? super F, ? extends T> transformer;

        TransformedIterator(Iterator<? extends F> backingIterator,Function<? super F, ? extends T> transformer) {
            this.backingIterator = checkNotNull(backingIterator);
            this.transformer = checkNotNull(transformer);
        }

        @Override
        public final boolean hasNext() {
            return backingIterator.hasNext();
        }

        @Override
        public final T next() {
            return transformer.apply(backingIterator.next());
        }

        @Override
        public final void remove() {
            backingIterator.remove();
        }
    }
    static class TransformedSet<E1, E2> extends AbstractSet<E2> {
        final Set<E1> fromSet;
        private final DualTransformer<E1, E2> transformer;

        TransformedSet(Set<E1> fromSet, DualTransformer<E1, E2> transformer) {
            checkNotNull(fromSet);
            checkNotNull(transformer);
            this.fromSet = fromSet;
            this.transformer = transformer;
        }
        @Override
        public int size() {
            return fromSet.size();
        }

        @Override
        public Iterator<E2> iterator() {
            return transform(fromSet.iterator(), asToRightTransformer(transformer));
        }

        @Override
        public boolean add(E2 e) {
            return fromSet.add(transformer.fromRight(e));
        }

        @SuppressWarnings("unchecked")
        @Override
        public boolean contains(Object o) {
            try {
                return fromSet.contains(transformer.fromRight((E2) o));
            } catch (ClassCastException e) {
                return false;
            }
        }

        @SuppressWarnings("unchecked")
        @Override
        public boolean remove(Object o) {
            try {
                return fromSet.remove(transformer.fromRight((E2) o));
            } catch (ClassCastException e) {
                return false;
            }
        }
    }

    static class TransformedMap<K1, K2, V> extends AbstractMap<K2, V> {
        final Map<K1, V> fromMap;
        private DualTransformer<K1,K2> transformer;
        TransformedMap(Map<K1, V> fromMap, DualTransformer<K1,K2> transformer) {
            checkNotNull(fromMap);
            checkNotNull(transformer);
            this.fromMap = fromMap;
            this.transformer = transformer;
        }
        @SuppressWarnings("unchecked")
        @Override
        public V get(Object key) {
            try {
                return fromMap.get(transformer.fromRight((K2) key));
            } catch (ClassCastException e) {
                return null;
            }
        }

        @SuppressWarnings("unchecked")
        @Override
        public boolean containsKey(Object key) {
            try {
                return fromMap.containsKey(transformer.fromRight((K2) key));
            } catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public V put(K2 key, V value) {            
            return fromMap.put(transformer.fromRight(key), value);
        }

        @SuppressWarnings("unchecked")
        @Override
        public V remove(Object key) {
            try {
                return fromMap.remove(transformer.fromRight((K2) key));
            } catch (ClassCastException e) {
                return null;
            }
        }

        @Override
        public Set<Entry<K2, V>> entrySet() {
            return new AbstractEntrySet<K2,V>(){

                @Override
                Map<K2, V> map() {
                    return TransformedMap.this;
                }

                @Override
                public Iterator<java.util.Map.Entry<K2, V>> iterator() {
                    return transform(fromMap.entrySet().iterator(),
                            new Function<Entry<K1,V>,Entry<K2,V>>(){
                        @Override
                        public java.util.Map.Entry<K2, V> apply(java.util.Map.Entry<K1, V> input) {
                            return new TransformedEntry<K1,K2,V>(input,asToRightTransformer(TransformedMap.this.transformer));
                        }});
                }};
        }
        abstract static class AbstractEntrySet<K, V> extends AbstractSet<Entry<K, V>> {
            /**
             * return  map instance
             * @return
             */
            abstract Map<K, V> map();

            @Override 
            public int size() {
                return map().size();
            }

            @Override 
            public boolean contains(Object o) {
                if (o instanceof Entry) {
                    Entry<?, ?> entry = (Entry<?, ?>) o;
                    Object key = entry.getKey();
                    V value = safeGet(map(), key);
                    return Objects.equals(value, entry.getValue())
                            && (value != null || map().containsKey(entry.getKey()));
                }
                return false;
            }

            @Override 
            public boolean remove(Object o) {
                if (contains(o)) {
                    Entry<?, ?> entry = (Entry<?, ?>) o;
                    return map().keySet().remove(entry.getKey());
                }
                return false;
            }
        }
        static class  TransformedEntry<K1,K2,V> implements Entry<K2, V> {
            final Entry<K1,V>fromEntry;
            final Function<K1, K2> transformer2;
            TransformedEntry(Entry<K1,V>fromEntry,Function<K1, K2> transformer2){
                checkNotNull(fromEntry);
                this.fromEntry = fromEntry;
                checkNotNull(transformer2);
                this.transformer2 = transformer2;
            }
            @Override
            public K2 getKey() {
                return transformer2.apply(fromEntry.getKey());
            }

            @Override
            public V getValue() {
                return fromEntry.getValue();
            }

            @Override
            public V setValue(V value) {
                return fromEntry.setValue(value);
            }

            @Override 
            public boolean equals(Object object) {
                if(object instanceof TransformedEntry){
                    return fromEntry.equals((TransformedEntry<?, ?, ?>)object);
                }
                return super.equals(object);
            }

            @Override 
            public int hashCode() {
                return fromEntry.hashCode();
            }

            @Override 
            public String toString() {
                return fromEntry.toString();
            }
        }
    }
}
