/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static final <T> T[] cleanNull(T[] array) {
        if (null == array || array.length == 0) {
            return array;
        }
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length);
        int c = 0;
        for (int i = 0; i < array.length; ++i) {
            if (null == array[i]) continue;
            copy[c++] = array[i];
        }
        return c == array.length ? array : Arrays.copyOf(copy, c);
    }

    public static int indexOfFirstNull(Object ... objects) {
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (null != objects[i]) continue;
                return i;
            }
            return -1;
        }
        return -2;
    }

    public static boolean hasNull(Object ... objects) {
        return ArrayUtils.indexOfFirstNull(objects) != -1;
    }

    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }
}

