/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class CmdExecutor {
    private static final Logger logger = Logger.getLogger(CmdExecutor.class.getSimpleName());
    private static final String SUDO_CMD = "sudo";
    private static final String SHELL_NAME = "/bin/bash";
    private static final String SHELL_PARAM = "-c";
    private static final String REDIRECT = "2>&1";
    private final String sudoPassword;
    private boolean verbose = true;
    private boolean errRedirect = true;
    private boolean sync = true;
    private String cmdSeparator = " && ";
    private List<String> cmds = new ArrayList<String>(16);

    public static CmdExecutor builder() {
        return new CmdExecutor();
    }

    public static CmdExecutor builder(String sudoPasword) {
        return new CmdExecutor(sudoPasword);
    }

    protected CmdExecutor() {
        this(null);
    }

    protected CmdExecutor(String sudoPasword) {
        this.sudoPassword = sudoPasword;
    }

    public CmdExecutor verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public CmdExecutor errRedirect(boolean errRedirect) {
        this.errRedirect = errRedirect;
        return this;
    }

    public CmdExecutor sync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public CmdExecutor cmdSeparator(String cmdSeparator) {
        if (null != cmdSeparator && !cmdSeparator.isEmpty()) {
            this.cmdSeparator = cmdSeparator;
        }
        return this;
    }

    private String getRedirect() {
        return this.errRedirect ? REDIRECT : "";
    }

    public CmdExecutor sudoCmd(String cmd) {
        if (null != cmd && 0 != cmd.length()) {
            if (null == this.sudoPassword) {
                this.cmds.add(String.format("%s %s %s", SUDO_CMD, cmd, this.getRedirect()));
            } else {
                this.cmds.add(String.format("echo '%s' | %s %s %s", this.sudoPassword, SUDO_CMD, cmd, this.getRedirect()));
            }
        }
        return this;
    }

    public CmdExecutor cmd(String cmd) {
        if (null != cmd && 0 != cmd.length()) {
            this.cmds.add(String.format("%s %s", cmd, this.getRedirect()));
        }
        return this;
    }

    private List<String> build() {
        return this.cmds.isEmpty() ? Collections.emptyList() : Arrays.asList(SHELL_NAME, SHELL_PARAM, CmdExecutor.join(this.cmds, this.cmdSeparator));
    }

    private static String join(List<String> strs, String separator) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < strs.size(); ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(strs.get(i));
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toBuffer(InputStream in, StringBuffer buffer) throws IOException {
        if (null == in || null == buffer) {
            return;
        }
        InputStreamReader ir = new InputStreamReader(in);
        try (LineNumberReader input = new LineNumberReader(ir);){
            String line;
            while ((line = input.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
    }

    public String exec() throws IOException {
        StringBuffer outBuffer = new StringBuffer();
        this.exec(outBuffer, null);
        return outBuffer.toString();
    }

    public void exec(StringBuffer outBuffer, StringBuffer errBuffer) throws IOException {
        List<String> cmdlist = this.build();
        if (!cmdlist.isEmpty()) {
            if (this.verbose) {
                logger.info(CmdExecutor.join(cmdlist, " "));
            }
            Process process = Runtime.getRuntime().exec(cmdlist.toArray(new String[cmdlist.size()]));
            if (this.sync) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            CmdExecutor.toBuffer(process.getInputStream(), outBuffer);
            CmdExecutor.toBuffer(process.getErrorStream(), errBuffer);
        }
    }
}

