/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.gdface.utils.Assert;
import net.gdface.utils.Judge;

public class FaceUtilitsX {
    private static Boolean IS_BUILDING = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFormatName(byte[] img) throws IllegalArgumentException, IOException {
        Assert.notEmpty(img, "img");
        Iterator<ImageReader> it = ImageIO.getImageReaders(new MemoryCacheImageInputStream(new ByteArrayInputStream(img)));
        if (!it.hasNext()) {
            throw new IOException("UNRECOGNIZED IMG FORMAT");
        }
        ImageReader reader = it.next();
        try {
            String string = reader.getFormatName();
            return string;
        }
        finally {
            reader.dispose();
        }
    }

    public static final boolean isBuilding() {
        if (null == IS_BUILDING) {
            IS_BUILDING = Boolean.valueOf(FaceUtilitsX.getRuntimeProperty("is_building"));
        }
        return IS_BUILDING;
    }

    public static File getAxis2Conf() throws FileNotFoundException {
        String tomcat = System.getenv("CATALINA_HOME");
        if (Judge.isEmpty(tomcat)) {
            throw new FileNotFoundException("NOT DEFINED environment variable CATALINA_HOME,can't locate configuration file");
        }
        File conf = new File(tomcat + "/webapps/axis2/WEB-INF/conf");
        if (!conf.exists() || !conf.isDirectory()) {
            throw new FileNotFoundException(String.format("NOT FOUND %s for configuration file", conf));
        }
        return conf;
    }

    public static final boolean notLoadCodeTable() {
        return Boolean.valueOf(FaceUtilitsX.getRuntimeProperty("notLoadCodeTable"));
    }

    public static final String getRuntimeProperty(String key) {
        String value = System.getProperty(key);
        if (null == value) {
            value = System.getenv(key);
        }
        System.out.printf("environment variable(java property)  %s=%b\n", key, Boolean.valueOf(value));
        return value;
    }
}

