/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Set;
import net.gdface.utils.Assert;
import net.gdface.utils.SimpleLog;
import net.gdface.utils.SimpleTypes;

public class InterfaceContainer<I> {
    private final Set<I> listeners = new LinkedHashSet<I>();
    private final Class<I> interfaceClass;
    private boolean skipOnError = true;
    private boolean logOnError = false;
    public final I container;

    protected InterfaceContainer() {
        this.interfaceClass = SimpleTypes.getRawClassOfSuperPamamType(this.getClass())[0];
        if (!this.interfaceClass.isInterface()) {
            throw new IllegalArgumentException("param I must be interface");
        }
        this.container = this.proxyInstance();
    }

    public InterfaceContainer(Class<I> interfaceClass) {
        Assert.notNull(interfaceClass, "interfaceClass");
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("param I must be interface");
        }
        this.interfaceClass = interfaceClass;
        this.container = this.proxyInstance();
    }

    private final I proxyInstance() {
        return this.interfaceClass.cast(Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)new Handler()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(I listener) {
        if (listener != null) {
            InterfaceContainer interfaceContainer = this;
            synchronized (interfaceContainer) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(I listener) {
        if (listener != null) {
            InterfaceContainer interfaceContainer = this;
            synchronized (interfaceContainer) {
                this.listeners.remove(listener);
            }
        }
    }

    public InterfaceContainer<I> setSkipOnError(boolean skipOnError) {
        this.skipOnError = skipOnError;
        return this;
    }

    public InterfaceContainer<I> setLogOnError(boolean logOnError) {
        this.logOnError = logOnError;
        return this;
    }

    private class Handler
    implements InvocationHandler {
        private Handler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (Object listener : InterfaceContainer.this.listeners) {
                try {
                    method.invoke(listener, args);
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (InterfaceContainer.this.skipOnError) {
                        if (!InterfaceContainer.this.logOnError) continue;
                        SimpleLog.log("ERROR:" + te.getMessage(), te);
                        continue;
                    }
                    throw te;
                }
                catch (Throwable e) {
                    throw e;
                }
            }
            return null;
        }
    }
}

