/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import net.gdface.utils.BaseInterfaceDecorator;
import net.gdface.utils.ConditionChecks;

public class InterfaceNonimplDecorator<I>
extends BaseInterfaceDecorator<I, Object> {
    protected final Map<Method, Method> invokeMethods = new Hashtable<Method, Method>();
    private final boolean lenient;

    public InterfaceNonimplDecorator(Class<I> interfaceClass, Object delegate, boolean lenient) {
        super(interfaceClass, ConditionChecks.checkNotNull(delegate, "delegate is null", new Object[0]));
        this.lenient = lenient;
        try {
            this.compile(interfaceClass, delegate);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public InterfaceNonimplDecorator(Class<I> interfaceClass, Object delegate) {
        this(interfaceClass, delegate, true);
    }

    private static boolean isVoid(Class<?> type) {
        return Void.class.equals(type) || Void.TYPE.equals(type);
    }

    protected void compile(Class<I> interfaceClass, Object delegate) throws NoSuchMethodException {
        Class<?> delegateClass = delegate.getClass();
        for (Method im : interfaceClass.getMethods()) {
            Method dm;
            Class<?>[] parameterTypes = im.getParameterTypes();
            Class<?> imReturnType = im.getReturnType();
            if (!(imReturnType.isAssignableFrom((dm = delegateClass.getMethod(im.getName(), parameterTypes)).getReturnType()) || this.lenient && InterfaceNonimplDecorator.isVoid(imReturnType))) {
                throw new NoSuchMethodException(String.format("Mismatch return type with %s,%s", dm, im));
            }
            this.invokeMethods.put(im, delegateClass.getMethod(im.getName(), parameterTypes));
        }
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = this.invokeMethods.get(method).invoke(this.delegate, args);
        return result != null && InterfaceNonimplDecorator.isVoid(method.getReturnType()) ? null : result;
    }
}

