/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gdface.utils.Platform;

public class SimpleLog {
    private static final String DELIM_STR = "(\\{\\}|%s)";
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final OutputString outputString = SimpleLog.createOutputString();

    private static OutputString createOutputString() {
        if (Platform.isAndroid()) {
            return new AndroidOutput();
        }
        return new StandardOutput();
    }

    public static String logString(String format, Object ... args) {
        if (null == format) {
            return "";
        }
        if (null == args) {
            args = EMPTY_ARGS;
        }
        StringBuilder buffer = new StringBuilder(format.length() + 64);
        int beginIndex = 0;
        int count = 0;
        Pattern pattern = Pattern.compile(DELIM_STR);
        Matcher matcher = pattern.matcher(format);
        while (matcher.find()) {
            buffer.append(format.substring(beginIndex, matcher.start()));
            try {
                buffer.append(args[count++]);
            }
            catch (IndexOutOfBoundsException e) {
                buffer.append("null");
            }
            beginIndex = matcher.end();
        }
        buffer.append(format.substring(beginIndex, format.length()));
        return buffer.toString();
    }

    private static void log(PrintStream printStream, int level, String format, Object ... args) {
        if (null == printStream) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        StackTraceElement stackTrace = currentThread.getStackTrace()[level];
        printStream.printf("[%s] (%s:%d) %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), SimpleLog.logString(format, args));
    }

    private static void log(OutputString outputString, Level level, String format, Object ... args) {
        if (null == outputString) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        StackTraceElement stackTrace = currentThread.getStackTrace()[outputString.stackLeve()];
        outputString.log(level, String.format("[%s] (%s:%d) %s %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), stackTrace.getMethodName(), SimpleLog.logString(format, args)));
    }

    public static void log(PrintStream printStream, String format, Object ... args) {
        SimpleLog.log(printStream, 3, format, args);
    }

    public static void log(boolean output, PrintStream printStream, String format, Object ... args) {
        if (output) {
            SimpleLog.log(printStream, 3, format, args);
        }
    }

    private static final String formatByCount(int c) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("{}");
        }
        return buffer.toString();
    }

    public static void logObjects(Object arg) {
        SimpleLog.log(outputString, Level.INFO, SimpleLog.formatByCount(1), arg);
    }

    public static void logObjects(Object arg, Object ... args) {
        Object[] array = new Object[args.length + 1];
        array[0] = arg;
        System.arraycopy(args, 0, array, 1, args.length);
        SimpleLog.log(outputString, Level.INFO, SimpleLog.formatByCount(args.length), array);
    }

    public static void log(String format, Object ... args) {
        SimpleLog.log(outputString, Level.INFO, format, args);
    }

    public static void log(boolean output, String format, Object ... args) {
        if (output) {
            SimpleLog.log(outputString, Level.INFO, format, args);
        }
    }

    public static void log(String msg, Throwable e) {
        SimpleLog.log(outputString, Level.ERROR, "{}\n{}", msg, SimpleLog.stackTraceOf(e));
    }

    public static void log(Throwable e) {
        SimpleLog.log(outputString, Level.ERROR, "{}", SimpleLog.stackTraceOf(e));
    }

    public static final String stackTraceOf(Throwable e) {
        if (e == null) {
            e = new NullPointerException("e is null");
        }
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString();
    }

    static class AndroidOutput
    implements OutputString {
        public static final String DEFAULT_TAG = "SIMPLE_LOG";
        private final String defaultTag;
        private final Map<Level, Method> methods = new HashMap<Level, Method>();

        public AndroidOutput(String defaultTag) {
            this.defaultTag = null == defaultTag ? DEFAULT_TAG : defaultTag;
            this.methods.put(Level.INFO, AndroidOutput.methodOfLog("i"));
            this.methods.put(Level.ERROR, AndroidOutput.methodOfLog("e"));
        }

        public AndroidOutput() {
            this(null);
        }

        static Method methodOfLog(String name) {
            try {
                Class<?> logClass = Class.forName("android.util.Log");
                return logClass.getMethod(name, String.class, String.class);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("UNSUPPORTED PLATFORM,android reqiured");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void log(Level level, String message) {
            try {
                this.methods.get((Object)level).invoke(null, this.defaultTag, String.valueOf(message));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int stackLeve() {
            return 4;
        }
    }

    static class StandardOutput
    implements OutputString {
        final Map<Level, PrintStream> streams = new HashMap<Level, PrintStream>();

        public StandardOutput() {
            this.streams.put(Level.INFO, System.out);
            this.streams.put(Level.ERROR, System.err);
        }

        @Override
        public void log(Level level, String message) {
            this.streams.get((Object)level).print(String.valueOf(message));
        }

        @Override
        public int stackLeve() {
            return 3;
        }
    }

    static interface OutputString {
        public void log(Level var1, String var2);

        public int stackLeve();
    }

    static enum Level {
        INFO,
        ERROR;

    }
}

