/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils.encrypt;

import java.nio.charset.Charset;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.gdface.utils.Base64Utils;
import net.gdface.utils.ConditionChecks;

public class AES128ECBNoPadding {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static byte[] encrypt(byte[] sSrc, byte[] sKey) throws Exception {
        ConditionChecks.checkArgument(null != sSrc, "sSrc is null", new Object[0]);
        ConditionChecks.checkArgument(null != sKey, "sKey is null", new Object[0]);
        ConditionChecks.checkArgument(sKey.length == 16, "length of sKey must be 16 bytes", new Object[0]);
        SecretKeySpec skeySpec = new SecretKeySpec(sKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, skeySpec);
        return cipher.doFinal(sSrc);
    }

    public static String encrypt(String sSrc, String sKey) throws Exception {
        byte[] encrypted = AES128ECBNoPadding.encrypt(ConditionChecks.checkNotNull(sSrc, "sSrc is null", new Object[0]).getBytes(UTF_8), ConditionChecks.checkNotNull(sKey, "sKey is null", new Object[0]).getBytes(UTF_8));
        return Base64Utils.encode(encrypted);
    }

    public static byte[] decrypt(byte[] sSrc, byte[] sKey) throws Exception {
        ConditionChecks.checkArgument(null != sSrc, "sSrc is null", new Object[0]);
        ConditionChecks.checkArgument(null != sKey, "sKey is null", new Object[0]);
        ConditionChecks.checkArgument(sKey.length == 16, "length of sKey must be 16 bytes", new Object[0]);
        SecretKeySpec skeySpec = new SecretKeySpec(sKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, skeySpec);
        return cipher.doFinal(sSrc);
    }

    public static String decrypt(String sSrc, String sKey) throws Exception {
        byte[] decoded = AES128ECBNoPadding.decrypt(Base64Utils.decode(ConditionChecks.checkNotNull(sSrc, "sSrc is null", new Object[0])), ConditionChecks.checkNotNull(sKey, "sKey is null", new Object[0]).getBytes(UTF_8));
        return new String(decoded, UTF_8);
    }

    public static byte[] wrapEncrypt(byte[] sSrc, byte[] sKey) throws Exception {
        ConditionChecks.checkArgument(null != sSrc, "sSrc is null", new Object[0]);
        ConditionChecks.checkArgument(null != sKey, "sKey is null", new Object[0]);
        ConditionChecks.checkArgument(sKey.length <= 32, "too long sKey", new Object[0]);
        byte[] paddingKey = sKey;
        byte[] paddingSrc = new byte[sSrc.length + 4];
        paddingSrc[0] = (byte)sSrc.length;
        paddingSrc[1] = (byte)(sSrc.length >> 8);
        paddingSrc[2] = (byte)(sSrc.length >> 16);
        paddingSrc[3] = (byte)(sSrc.length >> 24);
        System.arraycopy(sSrc, 0, paddingSrc, 4, sSrc.length);
        if (paddingSrc.length % 16 != 0) {
            paddingSrc = Arrays.copyOf(paddingSrc, (paddingSrc.length + 16 - 1) / 16 * 16);
        }
        if (sKey.length % 8 != 0) {
            int padSize = Math.max(16, (sKey.length + 8 - 1) / 8 * 8);
            paddingKey = Arrays.copyOf(sKey, padSize);
        }
        return AES128ECBNoPadding.encrypt(paddingSrc, paddingKey);
    }

    public static String wrapEncrypt(String sSrc, String sKey) throws Exception {
        byte[] encrypted = AES128ECBNoPadding.wrapEncrypt(ConditionChecks.checkNotNull(sSrc, "sSrc is null", new Object[0]).getBytes(UTF_8), ConditionChecks.checkNotNull(sKey, "sKey is null", new Object[0]).getBytes(UTF_8));
        return Base64Utils.encode(encrypted);
    }

    public static byte[] wrapDecrypt(byte[] sSrc, byte[] sKey) throws Exception {
        byte[] wrap;
        int wrapLength;
        ConditionChecks.checkArgument(null != sSrc, "sSrc is null", new Object[0]);
        ConditionChecks.checkArgument(null != sKey, "sKey is null", new Object[0]);
        ConditionChecks.checkArgument(sKey.length <= 32, "too long sKey", new Object[0]);
        byte[] paddingKey = sKey;
        if (sKey.length % 8 != 0) {
            int padSize = Math.max(16, (sKey.length + 8 - 1) / 8 * 8);
            paddingKey = Arrays.copyOf(sKey, padSize);
        }
        ConditionChecks.checkArgument((wrapLength = (wrap = AES128ECBNoPadding.decrypt(sSrc, paddingKey))[0] & 0xFF | wrap[1] << 8 & 0xFF00 | wrap[2] << 16 & 0xFF0000 | wrap[3] << 24 & 0xFF000000) > 0 && wrapLength < wrap.length, "INVALID wrap length %s", wrapLength);
        byte[] data = new byte[wrapLength];
        System.arraycopy(wrap, 4, data, 0, wrapLength);
        return data;
    }

    public static String wrapDecrypt(String sSrc, String sKey) throws Exception {
        byte[] decoded = AES128ECBNoPadding.wrapDecrypt(Base64Utils.decode(ConditionChecks.checkNotNull(sSrc, "sSrc is null", new Object[0])), ConditionChecks.checkNotNull(sKey, "sKey is null", new Object[0]).getBytes(UTF_8));
        return new String(decoded, UTF_8);
    }

    public static void main(String[] args) throws Exception {
        String cKey = "WllNRVNTQUdFOTk@";
        String cSrc = "@FACE@Android@2@20200218@V2.3.5.1@05352CF3086932E2@@            ";
        System.out.println("\u5f85\u52a0\u5bc6\u7684\u5b57\u4e32\u662f\uff1a" + cSrc);
        String enString = AES128ECBNoPadding.encrypt(cSrc, cKey);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u5b57\u4e32\u662f\uff1a" + enString);
        String DeString = AES128ECBNoPadding.decrypt(enString, cKey);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u5b57\u4e32\u662f\uff1a" + DeString);
        System.out.println("/////////////////// WRAP TEST////////////////////////");
        String cKey2 = "WllNRVNTQUdFOTk";
        String cSrc2 = "{\"channel\":\"1610176971640\",\"qrCodeSceneId\":\"16169887538401\",\"IDcardSceneId\":\"16169887538402\",\"publicKey\":\"04A866F61DA13F8FA893A5C44D131D051FECBAE2C2F045978A17C815E7B1DE108519F5D5A7DE7D17A42BD407BA6503CEFB4C18E1940FEF9153047F3798B8A8C87D\",\"privateKey\":\"00B69D059FDC1B65E41608A5CA72A527FBB2FBC67ECA87999B3F56E65BC46610EE\",\"position\":\"\u6c5f\u82cf\u7701,\u5357\u4eac\u5e02,\u9f13\u697c\u533a\",\"verifierDept\":\"XXX\u533b\u9662\",\"verifierName\":\"XXX\",\"verifierPhone\":\"18888888888\",\"location\":\"32.0238\u3001118.4643\"}";
        System.out.println("\u5f85\u52a0\u5bc6\u7684\u5b57\u4e32\u662f\uff1a" + cSrc2 + " \u957f\u5ea6:" + cSrc2.length());
        String enString2 = AES128ECBNoPadding.wrapEncrypt(cSrc2, cKey2);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u5b57\u4e32\u662f\uff1a" + enString2);
        String deString2 = AES128ECBNoPadding.wrapDecrypt(enString2, cKey2);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u5b57\u4e32\u662f\uff1a" + deString2 + " \u957f\u5ea6:" + deString2.length());
    }
}

