/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils.encrypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import net.gdface.utils.encrypt.AES128ECBNoPadding;

public class EncryptedProperties
extends Properties {
    private static final long serialVersionUID = 2102942876991337031L;
    private final String password;
    private final LinkedHashSet<String> protectedKeys = new LinkedHashSet();
    private final boolean protecteAll;
    private boolean trans;

    public EncryptedProperties(Properties properties, String password, Iterable<String> protectedKeys) {
        this.password = password;
        if (null != protectedKeys) {
            for (String protectedKey : protectedKeys) {
                if (null == protectedKey || protectedKey.length() <= 0) continue;
                this.protectedKeys.add(protectedKey);
            }
            this.protecteAll = this.protectedKeys.isEmpty();
        } else {
            this.protecteAll = true;
        }
        if (null != properties) {
            this.putAll((Map<?, ?>)properties);
        }
        this.trans = true;
    }

    public EncryptedProperties(String password, Iterable<String> protectedKeys) {
        this(null, password, protectedKeys);
    }

    private EncryptedProperties(Builder builder) {
        this(builder.properties, builder.password, builder.protectedKeys);
    }

    @Override
    public String getProperty(String key) {
        Object oval = this.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    @Override
    public synchronized Object get(Object key) {
        Object value = super.get(key);
        if (this.trans && value instanceof String && this.password != null && this.password.length() > 0 && (this.protecteAll || this.protectedKeys.contains(key))) {
            try {
                return AES128ECBNoPadding.wrapDecrypt((String)value, this.password);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (this.trans && value instanceof String && this.password != null && this.password.length() > 0 && (this.protecteAll || this.protectedKeys.contains(key))) {
            try {
                value = AES128ECBNoPadding.wrapEncrypt((String)value, this.password);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.put(key, value);
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        try {
            this.trans = false;
            super.store(writer, comments);
        }
        finally {
            this.trans = true;
        }
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        try {
            this.trans = false;
            super.store(out, comments);
        }
        finally {
            this.trans = true;
        }
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        try {
            this.trans = false;
            super.storeToXML(os, comment);
        }
        finally {
            this.trans = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        try {
            this.trans = false;
            super.storeToXML(os, comment, encoding);
        }
        finally {
            this.trans = true;
        }
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        try {
            this.trans = false;
            super.load(reader);
        }
        finally {
            this.trans = true;
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        try {
            this.trans = false;
            super.load(inStream);
        }
        finally {
            this.trans = true;
        }
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        try {
            this.trans = false;
            super.loadFromXML(in);
        }
        finally {
            this.trans = true;
        }
    }

    @Override
    public String toString() {
        int max = this.size() - 1;
        if (max == -1) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Object> it = this.keySet().iterator();
        sb.append('{');
        int i = 0;
        while (true) {
            Object key = it.next();
            Object value = this.get(key);
            sb.append(key == this ? "(this Map)" : key.toString());
            sb.append('=');
            sb.append(value == this ? "(this Map)" : value.toString());
            if (i == max) {
                return sb.append('}').toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EncryptedProperties wrap(Properties properties, String password, Iterable<String> protectedKeys) {
        if (properties instanceof EncryptedProperties) {
            return (EncryptedProperties)properties;
        }
        return new EncryptedProperties(properties, password, protectedKeys);
    }

    public static class Builder {
        private Properties properties = new Properties();
        private String password;
        private LinkedHashSet<String> protectedKeys = new LinkedHashSet();

        private Builder() {
        }

        public Builder properties(Properties properties) {
            if (null != properties) {
                this.properties = properties;
            }
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder protectedKeys(Iterable<String> protectedKeys) {
            if (null != protectedKeys) {
                for (String key : protectedKeys) {
                    this.protectedKey(key);
                }
            }
            return this;
        }

        public Builder protectedKeys(String ... protectedKeys) {
            if (null != protectedKeys) {
                for (String key : protectedKeys) {
                    this.protectedKey(key);
                }
            }
            return this;
        }

        public Builder protectedKey(String protectedKey) {
            if (null != protectedKey && protectedKey.length() > 0) {
                this.protectedKeys.add(protectedKey);
            }
            return this;
        }

        public Builder protectedAll() {
            this.protectedKeys.clear();
            return this;
        }

        public EncryptedProperties build() {
            return new EncryptedProperties(this);
        }

        public EncryptedProperties wrap() {
            return EncryptedProperties.wrap(this.properties, this.password, this.protectedKeys);
        }
    }
}

