/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.gdface.web.Response;
import net.gdface.web.TranformValueException;

public class DefaultResponse
implements Response {
    private static boolean outStrackTrace = false;
    private boolean success;
    private Object result;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String errorMessage;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String stackTrace;
    @JsonIgnore
    private Object delegate;
    @JsonIgnore
    private Exception error;

    @Override
    public void onComplete(Object result) {
        this.success = true;
        this.result = result;
        this.errorMessage = null;
        this.stackTrace = null;
    }

    @Override
    public void onComplete() {
        this.onComplete(null);
    }

    @Override
    public void onError(Exception e) {
        if (e instanceof TranformValueException) {
            this.onComplete(((TranformValueException)e).getResult());
            return;
        }
        this.success = false;
        this.result = null;
        this.errorMessage = e.getMessage();
        this.error = e;
        if (this.errorMessage == null) {
            this.errorMessage = e.getClass().getSimpleName();
        }
        if (outStrackTrace) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.stackTrace = writer.toString();
        }
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Override
    public Object delegate() {
        return this.delegate;
    }

    @Override
    public Exception error() {
        return this.error;
    }

    @Override
    public void delegate(Object delegate) {
        this.delegate = delegate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultResponse [success=");
        builder.append(this.success);
        builder.append(", ");
        if (this.result != null) {
            builder.append("result=");
            builder.append(this.result);
            builder.append(", ");
        }
        if (this.errorMessage != null) {
            builder.append("errorMessage=");
            builder.append(this.errorMessage);
            builder.append(", ");
        }
        if (this.stackTrace != null) {
            builder.append("stackTrace=");
            builder.append(this.stackTrace);
        }
        builder.append("]");
        return builder.toString();
    }

    public static void enableStrackTrace() {
        outStrackTrace = true;
    }
}

