package net.gdface.annotations;

import net.gdface.json.JsonSupport;

/**
 * @author guyadong
 * @since 2.7.0
 */
public class AnnotationSupport {
	/**
	 * 创建指定的{@link JsonSupport}子类实例<br>
	 * 如果获取{@link ActiveOnClass}注解失败或注解中name字段指定的类不存在则代表子类依赖的库不存在，返回null
	 * @param clazz
	 */
	public static <T>T createInstanceIfActiveClassPresent(Class<T> clazz){
		try {
			/** 获取注解失败或注解中name字段指定的类不存在则返回null */
			ActiveOnClass annot = clazz.getAnnotation(ActiveOnClass.class);
			if(null != annot){
				for(String className:annot.name()){
					Class.forName(className);
				}
			}
			return clazz.newInstance();
		} catch (Throwable e) {
		}
		return null;
	}
	/**
	 * 基于{@link ActiveOnClass}注解判断指定的是否是可激活的 <br>
	 * 如果获取{@link ActiveOnClass}注解失败或注解中name字段指定的类不存在则代表子类依赖的库不存在，返回{@code false}，否则返回{@code true}
	 * @param clazz 为{@code null}返回{@code false}
	 * @since 2.8.0
	 */
	public static boolean isActive(Class<?> clazz){
		if(null != clazz) {
			try {
				/** 获取注解失败或注解中name字段指定的类不存在则返回null */
				ActiveOnClass annot = clazz.getAnnotation(ActiveOnClass.class);
				if(null != annot){
					for(String className:annot.name()){
						Class.forName(className);
					}
				}
				return true;
			} catch (Throwable e) {
			}
		}
		return false;
	}
}
