package net.gdface.bean.openbeans.factory;

import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.PropertyDescriptor;

import gu.sql2java.RowMetaData;
import gu.sql2java.UnnameRow;
import net.gdface.annotations.ActiveOnClass;
import net.gdface.bean.openbeans.descriptor.UnnameRowPropertyDescriptor;

/**
 * @author guyadong
 * @since 2.7.0
 *
 */
@ActiveOnClass(UnnameRow.class)
public class UnnameRowDescriptorFactory implements PropertyDescriptorFactory {

	@Override
	public PropertyDescriptor descriptorOf(Object bean, String name) throws IntrospectionException {
		if(bean instanceof UnnameRow ){
			RowMetaData metaData = ((UnnameRow)bean).fetchMetaData();
			if(metaData.columnIDOf(name) >= 0){
				return new UnnameRowPropertyDescriptor(metaData,name);
			}
		}
		return null;
	}

}
