/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.bean;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.gdface.annotations.AnnotationSupport;
import net.gdface.bean.BeanDifference;
import net.gdface.bean.NameResolver;
import net.gdface.bean.NestedNodeVisitor;
import net.gdface.bean.exception.BeanPropertyRuntimeException;
import net.gdface.bean.exception.CycleReferenceException;
import net.gdface.bean.jdk.BeanPropertySupportImpl;
import net.gdface.json.JsonSupports;
import net.gdface.reflection.MethodUtils;
import net.gdface.utils.CaseSupport;

public abstract class BeanPropertySupport {
    public static final BeanPropertySupport BEAN_SUPPORT;
    private final NameResolver resolver = new NameResolver();
    protected static final Object[] EMPTY_OBJECT_ARRAY;
    protected static boolean traceEnabled;

    protected BeanPropertySupport() {
    }

    public abstract Set<String> getPropertyNames(Class<?> var1, int var2, boolean var3);

    public Set<String> getPropertyNames(Object bean, int rw, boolean lenient) {
        return null == bean ? Collections.emptySet() : this.getPropertyNames(bean.getClass(), rw, lenient);
    }

    public abstract void clearDescriptors();

    public Object getProperty(Object bean, String name) {
        return this.getProperty(bean, name, null);
    }

    public Object getProperty(Object bean, String name, Object defaultValue) throws BeanPropertyRuntimeException {
        try {
            Object value = this.getPropertyChecked(bean, name);
            if (null == value) {
                return defaultValue;
            }
            if (null != defaultValue && !defaultValue.getClass().isInstance(value) && BeanPropertySupport.maybeJsonString(value) > 0) {
                return JsonSupports.jsonSupportInstance().parseOrEmptyMap((String)value, false);
            }
            return value;
        }
        catch (NoSuchMethodException e) {
            return defaultValue;
        }
        catch (ReflectiveOperationException e) {
            throw new BeanPropertyRuntimeException(e);
        }
        catch (IndexOutOfBoundsException e) {
            return defaultValue;
        }
    }

    public <T> T getPropertyCheckType(Object bean, String name, Class<T> targetType) throws BeanPropertyRuntimeException {
        try {
            Object value = this.getPropertyChecked(bean, name);
            if (null == value) {
                return null;
            }
            if (null == targetType) {
                throw new NullPointerException("targetType is null");
            }
            try {
                return targetType.cast(value);
            }
            catch (ClassCastException e) {
                if (value instanceof String) {
                    return JsonSupports.jsonSupportInstance().parse((String)value, targetType);
                }
                throw e;
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new BeanPropertyRuntimeException(e);
        }
    }

    public Object getPropertyChecked(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return new NestedContext(bean, name, false).visit(new ReadVisitor());
    }

    protected Object getProperty0(Object bean, String name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        bean = this.resolver.isMapped(name) ? this.getMappedProperty(bean, name) : (this.resolver.isIndexed(name) ? this.getIndexedProperty(bean, name) : (this.resolver.isSearched(name) ? this.getSearchedProperty(bean, name) : this.getSimpleProperty(bean, name)));
        return bean;
    }

    protected Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getMappedProperty(bean, name, key);
    }

    protected abstract Object getMappedProperty(Object var1, String var2, String var3) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    protected Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int index;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (index < -2) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getIndexedProperty(bean, name, index);
    }

    protected abstract Object getIndexedProperty(Object var1, String var2, int var3) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    protected Object getSearchedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        String field = null;
        String conditionValue = null;
        try {
            field = this.resolver.getField(name);
            conditionValue = this.resolver.getValue(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (null == field || 0 == field.length() || null == conditionValue || 0 == conditionValue.length()) {
            throw new IllegalArgumentException("Invalid search property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getSearchedProperty(bean, name, field, conditionValue);
    }

    protected abstract Object getSearchedProperty(Object var1, String var2, String var3, Object var4) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    protected abstract Object getSimpleProperty(Object var1, String var2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    public Object setProperty(Object bean, String name, Object value) {
        try {
            return this.setPropertyChecked(bean, name, value);
        }
        catch (NoSuchMethodException e) {
            return bean;
        }
        catch (ReflectiveOperationException e) {
            throw new BeanPropertyRuntimeException(e);
        }
    }

    public Object setPropertyChecked(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return new NestedContext(bean, name, value).visit(new WriteVisitor());
    }

    protected Object setProperty0(Object bean, String name, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.resolver.isMapped(name)) {
            this.setMappedProperty(bean, name, value);
        } else if (this.resolver.isIndexed(name)) {
            this.setIndexedProperty(bean, name, value);
        } else {
            this.setSimpleProperty(bean, name, value);
        }
        return bean;
    }

    protected void setMappedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setMappedProperty(bean, name, key, value);
    }

    protected abstract void setMappedProperty(Object var1, String var2, String var3, Object var4) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    protected void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int index;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (index < -2) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setIndexedProperty(bean, name, index, value);
    }

    protected abstract void setIndexedProperty(Object var1, String var2, int var3, Object var4) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    protected void setOrAddIndexValue(String name, Object bean, int index, Object value) {
        if (null == bean) {
            throw new IllegalArgumentException("Property '" + name + "' is null ");
        }
        if (bean.getClass().isArray()) {
            switch (index) {
                case -1: {
                    Array.set(bean, 0, value);
                    break;
                }
                default: {
                    Array.set(bean, index, value);
                    break;
                }
            }
        } else if (bean instanceof List) {
            List list = (List)bean;
            switch (index) {
                case -1: {
                    list.add(0, value);
                    break;
                }
                case -2: {
                    list.add(value);
                    break;
                }
                default: {
                    list.set(index, value);
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
        }
    }

    protected Object getIndexValue(String name, Object bean, int index) {
        if (null == bean) {
            return null;
        }
        if (bean.getClass().isArray()) {
            try {
                switch (index) {
                    case -1: {
                        return Array.get(bean, 0);
                    }
                    case -2: {
                        return Array.get(bean, Array.getLength(bean) - 1);
                    }
                }
                return Array.get(bean, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + Array.getLength(bean) + " for property '" + name + "'");
            }
        }
        if (bean instanceof List) {
            List list = (List)bean;
            switch (index) {
                case -1: {
                    return list.get(0);
                }
                case -2: {
                    return list.get(list.size() - 1);
                }
            }
            return list.get(index);
        }
        throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
    }

    protected abstract void setSimpleProperty(Object var1, String var2, Object var3) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    public abstract void copyProperties(Object var1, Object var2);

    public abstract boolean isReadable(Object var1, String var2);

    public abstract boolean isWriteable(Object var1, String var2);

    public <T> BeanDifference createBeanDifference(final Function<T, Object> rightGetter) {
        if (null == rightGetter) {
            throw new NullPointerException("rightGetter is null");
        }
        return new BeanDifference(this){

            @Override
            protected Object left(Object right) {
                return rightGetter.apply(right);
            }
        };
    }

    public Map<String, Object> describe(Object bean) {
        return this.describe(bean, false);
    }

    public Map<String, Object> describe(Object bean, boolean throwOnCycleReference) {
        LinkedHashMap<String, Object> nodes = new LinkedHashMap<String, Object>();
        NestedContext nestedContext = new NestedContext(bean, null, throwOnCycleReference);
        nestedContext.describe(nodes);
        return nodes;
    }

    public boolean hasCycleReference(Object bean) {
        try {
            this.checkCycleReference(bean);
            return false;
        }
        catch (CycleReferenceException e) {
            return true;
        }
    }

    public void checkCycleReference(Object bean) throws CycleReferenceException {
        new NestedContext(bean, null, true).describe(null);
    }

    public Map<String, DiffNode> different(Object left, Object right) {
        return this.different(left, right, null, null, true, new String[0]);
    }

    public Map<String, DiffNode> different(Object left, Object right, String focusNames) {
        return this.different(left, right, (Predicate<String>)Predicates.alwaysTrue(), null, true, focusNames);
    }

    public Map<String, DiffNode> different(Object left, Object right, String ... focusNames) {
        return this.different(left, right, (Predicate<String>)Predicates.alwaysTrue(), null, true, focusNames);
    }

    public Map<String, DiffNode> different(Object left, Object right, Iterable<String> focusNames) {
        return this.different(left, right, (Predicate<String>)Predicates.alwaysTrue(), null, focusNames, true);
    }

    public Map<String, DiffNode> different(Object left, Object right, Predicate<String> originNameFilter, Iterable<String> focusNames) {
        return this.different(left, right, originNameFilter, null, focusNames, true);
    }

    public Map<String, DiffNode> different(Object left, Object right, Predicate<String> originNameFilter, String ... focusNames) {
        return this.different(left, right, originNameFilter, null, true, focusNames);
    }

    public Map<String, DiffNode> different(Object left, Object right, Predicate<String> originNameFilter, String[] forceExcludeNames, boolean includeRequired, String ... focusNames) {
        List<String> names = null == focusNames ? Collections.emptyList() : Arrays.asList(focusNames);
        List<String> excludeNames = null == forceExcludeNames ? Collections.emptyList() : Arrays.asList(forceExcludeNames);
        return this.different(left, right, originNameFilter, excludeNames, names, includeRequired);
    }

    public Map<String, DiffNode> different(Object left, Object right, Predicate<String> originNameFilter, Iterable<String> forceExcludeNames, Iterable<String> focusNames, boolean includeRequired) {
        if (null == left || null == right) {
            HashMap<String, DiffNode> map = new HashMap<String, DiffNode>();
            map.put(".", new DiffNode(left, right));
            return map;
        }
        NestedNameFilter nameFilter = new NestedNameFilter(originNameFilter, forceExcludeNames, focusNames, includeRequired);
        LinkedHashMap<String, DiffNode> diff = new LinkedHashMap<String, DiffNode>();
        this.different(left, right, diff, nameFilter);
        return diff;
    }

    private void different(Object left, Object right, Map<String, DiffNode> diff, Predicate<String> nameFilter) {
        Map<String, Object> descLeft = this.describe(left);
        Map<String, Object> descRight = this.describe(right);
        Iterator itor = Iterators.concat(descLeft.keySet().iterator(), descRight.keySet().iterator());
        while (itor.hasNext()) {
            String nestedName = (String)itor.next();
            if (!nameFilter.apply((Object)nestedName) || this.containOrParent(diff.keySet(), nestedName)) continue;
            if (nameFilter instanceof NestedNameFilter && !((NestedNameFilter)nameFilter).focusNames.isEmpty()) {
                this.addIfNoEqual(diff, nestedName, descLeft.get(nestedName), descRight.get(nestedName));
                continue;
            }
            Object lv = descLeft.get(nestedName);
            if (descRight.containsKey(nestedName)) {
                this.addIfNoEqual(diff, nestedName, lv, descRight.get(nestedName));
                continue;
            }
            Object rv = this.getProperty(right, nestedName);
            if (null != rv) {
                this.addIfNoEqual(diff, nestedName, lv, rv);
                continue;
            }
            String nk = nestedName;
            while (this.resolver.hasNested(nk) && !descRight.containsKey(nk = this.resolver.removeRight(nk))) {
            }
            this.addIfNoEqual(diff, nk, this.getProperty(left, nk), this.getProperty(right, nk));
        }
    }

    private boolean containOrParent(Set<String> names, String nestName) {
        if (names.contains(nestName)) {
            return true;
        }
        if (this.resolver.hasNested(nestName)) {
            for (String name : names) {
                if (!nestName.startsWith(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void addIfNoEqual(Map<String, DiffNode> diff, String name, Object lv, Object rv) {
        if (!Objects.deepEquals(lv, rv)) {
            diff.put(name, new DiffNode(this.differentValue(this.asAccessibleBean(lv)), this.differentValue(this.asAccessibleBean(rv))));
        }
    }

    private Object asAccessibleBean(Object bean) {
        if (BeanPropertySupport.maybeJsonString(bean) > 0) {
            return JsonSupports.jsonSupportInstance().parseOrEmptyMap((String)bean, false);
        }
        return bean;
    }

    private Object differentValue(Object input) {
        if (null == input) {
            return "null";
        }
        if (byte[].class.equals(input.getClass())) {
            return "[binary]" + Array.getLength(input) + "bytes";
        }
        if (input.getClass().isArray()) {
            return input.getClass().getComponentType().getSimpleName() + "[" + Array.getLength(input) + "]";
        }
        if (input instanceof Iterable) {
            return input.getClass().getSimpleName() + "[" + Iterables.size((Iterable)((Iterable)input)) + "] ";
        }
        return input;
    }

    protected Object searchIn(Object input, String field, Object conditionValue) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (input instanceof Iterable) {
            for (Object element : (Iterable)input) {
                if (!String.valueOf(this.getProperty0(element, field)).equals(String.valueOf(conditionValue))) continue;
                return element;
            }
            return null;
        }
        if (input instanceof Map) {
            return this.searchIn(((Map)input).values(), field, conditionValue);
        }
        if (null != input && input.getClass().isArray()) {
            int end_i = Array.getLength(input);
            for (int i = 0; i < end_i; ++i) {
                Object element = Array.get(input, i);
                if (!String.valueOf(this.getProperty0(element, field)).equals(String.valueOf(conditionValue))) continue;
                return element;
            }
            return null;
        }
        throw new IllegalArgumentException("Property '" + field + "' is not search on bean class '" + input.getClass() + "'");
    }

    protected abstract Object tryConstructIfNull(Object var1, Object var2, String var3, Class<?> var4) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    private static boolean isBaseType(Object object) {
        if (null == object) {
            return true;
        }
        Class<?> clazz = object.getClass();
        if (Primitives.unwrap(clazz).isPrimitive()) {
            return true;
        }
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Date) {
            return true;
        }
        if (clazz.isArray()) {
            return Primitives.unwrap(clazz.getComponentType()).isPrimitive();
        }
        return false;
    }

    public static void setTraceEnabled(boolean traceEnabled) {
        BeanPropertySupport.traceEnabled = traceEnabled;
        MethodUtils.setTraceEnabled(traceEnabled);
    }

    public static boolean isEmpty(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Iterator) {
            return !((Iterator)value).hasNext();
        }
        if (value instanceof Iterable) {
            return !((Iterable)value).iterator().hasNext();
        }
        if (value instanceof Enumeration) {
            return !((Enumeration)value).hasMoreElements();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }

    public static boolean isEmpty(boolean all, Iterable<Object> values) {
        if (!BeanPropertySupport.isEmpty(values)) {
            if (all) {
                Iterator<Object> itor = values.iterator();
                while (itor.hasNext()) {
                    if (BeanPropertySupport.isEmpty(itor.next())) continue;
                    return false;
                }
                return true;
            }
            Iterator<Object> itor = values.iterator();
            while (itor.hasNext()) {
                if (!BeanPropertySupport.isEmpty(itor.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isEmpty(boolean all, Object ... values) {
        if (!BeanPropertySupport.isEmpty(values)) {
            return BeanPropertySupport.isEmpty(all, Arrays.asList(values));
        }
        return true;
    }

    public static boolean allEmpty(Iterable<Object> values) {
        return BeanPropertySupport.isEmpty(true, values);
    }

    public static boolean allEmpty(Object ... values) {
        return BeanPropertySupport.isEmpty(true, values);
    }

    public static boolean hasEmpty(Iterable<Object> values) {
        return BeanPropertySupport.isEmpty(false, values);
    }

    public static boolean hasEmpty(Object ... values) {
        return BeanPropertySupport.isEmpty(false, values);
    }

    protected static int maybeJsonString(Object object) {
        String s;
        if (object instanceof String && (s = (String)object).length() > 1) {
            if (s.charAt(0) == '{' && s.charAt(s.length() - 1) == '}') {
                return 1;
            }
            if (s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                return 2;
            }
        }
        return 0;
    }

    static {
        if (AnnotationSupport.isActive(BeanPropertySupportImpl.class)) {
            BEAN_SUPPORT = BeanPropertySupportImpl.BEAN_SUPPORT;
        } else if (AnnotationSupport.isActive(net.gdface.bean.openbeans.BeanPropertySupportImpl.class)) {
            BEAN_SUPPORT = net.gdface.bean.openbeans.BeanPropertySupportImpl.BEAN_SUPPORT;
        } else {
            throw new ExceptionInInitializerError("MISS openbeans,CANT NOT CREATE BeanPropertySupport instance,must add dependency 'me.champeau.openbeans:openbeans:1.0.2' OR 'com.googlecode:openbeans:1.0'");
        }
        EMPTY_OBJECT_ARRAY = new Object[0];
        traceEnabled = false;
    }

    static class NestedNameFilter
    implements Predicate<String> {
        final Set<String> focusNames;
        final Predicate<String> nameFilter;
        final Set<String> forceExcludeNames;
        final boolean includeRequired;

        private Set<String> normalize(Iterable<String> input) {
            if (null != input) {
                Iterable filtered = Iterables.filter(input, (Predicate)Predicates.notNull());
                Iterable cameCaseNames = Iterables.transform((Iterable)filtered, (Function)new Function<String, String>(){

                    public String apply(String input) {
                        return CaseSupport.toCamelcase(input);
                    }
                });
                return Sets.newHashSet((Iterable)cameCaseNames);
            }
            return Collections.emptySet();
        }

        NestedNameFilter(Predicate<String> originNameFilter, Iterable<String> forceExcludeNames, Iterable<String> focusNames, boolean includeRequired) {
            this.nameFilter = (Predicate)MoreObjects.firstNonNull(originNameFilter, (Object)Predicates.alwaysTrue());
            this.focusNames = this.normalize(focusNames);
            this.forceExcludeNames = this.normalize(forceExcludeNames);
            this.includeRequired = includeRequired;
        }

        public boolean apply(String input) {
            boolean allowed = false;
            if (null != input) {
                if (CaseSupport.isSnakecase(input)) {
                    input = CaseSupport.toCamelcase(input);
                }
                if (this.forceExcludeNames.contains(input)) {
                    return false;
                }
                if (this.focusNames.isEmpty()) {
                    allowed = true;
                } else if (this.focusNames.contains(input)) {
                    allowed = true;
                } else {
                    for (String name : this.focusNames) {
                        if (input.length() > name.length()) {
                            if (!input.startsWith(name)) continue;
                            allowed = true;
                            break;
                        }
                        if (name.length() > input.length()) {
                            if (!name.startsWith(input)) continue;
                            allowed = true;
                            break;
                        }
                        if (!name.equals(input)) continue;
                        allowed = true;
                        break;
                    }
                }
            }
            if (this.includeRequired) {
                return allowed ? this.nameFilter.apply((Object)input) : false;
            }
            return allowed ? !this.nameFilter.apply((Object)input) : false;
        }
    }

    protected class WriteVisitor
    implements NestedNodeVisitor {
        protected WriteVisitor() {
        }

        @Override
        public boolean beforeVisit(NestedContext context) {
            if (context.bean == null) {
                throw new IllegalArgumentException("No bean specified");
            }
            if (context.name == null) {
                throw new IllegalArgumentException("No name specified for bean class '" + context.bean.getClass() + "'");
            }
            return false;
        }

        @Override
        public boolean beofreNext(NestedContext context) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            String next = BeanPropertySupport.this.resolver.next(context.parent.name);
            Class expectType = null;
            Object accessibleBean = context.parent.getAccessibleBean();
            if (accessibleBean instanceof Map) {
                expectType = LinkedHashMap.class;
                if (BeanPropertySupport.this.resolver.isIndexed(next)) {
                    expectType = LinkedList.class;
                    next = BeanPropertySupport.this.resolver.getProperty(next);
                }
            }
            context.bean = BeanPropertySupport.this.tryConstructIfNull(context.bean, accessibleBean, next, expectType);
            return false;
        }

        @Override
        public boolean afterNext(NestedContext context) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            if (BeanPropertySupport.maybeJsonString(context.bean) > 0) {
                context.bean = JsonSupports.jsonSupportInstance().toJSONString(context.convertObject);
                BeanPropertySupport.this.setProperty0(context.parent.bean, BeanPropertySupport.this.resolver.getProperty(context.parent.name), context.bean);
                return true;
            }
            if (BeanPropertySupport.maybeJsonString(context.parent.bean) > 0) {
                context.parent.bean = JsonSupports.jsonSupportInstance().toJSONString(context.parent.convertObject);
                return true;
            }
            return false;
        }

        @Override
        public boolean lastNode(NestedContext context) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            if (context.checkCycleRef(context.value)) {
                throw new CycleReferenceException(context.name, String.valueOf(context.value));
            }
            BeanPropertySupport.this.setProperty0(context.getAccessibleBean(), context.name, context.value);
            return false;
        }
    }

    protected class ReadVisitor
    implements NestedNodeVisitor {
        protected ReadVisitor() {
        }

        @Override
        public boolean beforeVisit(NestedContext context) {
            return context.bean == null || context.name == null;
        }

        @Override
        public boolean beofreNext(NestedContext context) {
            return null == context.bean;
        }

        @Override
        public boolean afterNext(NestedContext context) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            return false;
        }

        @Override
        public boolean lastNode(NestedContext context) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            context.value = BeanPropertySupport.this.getProperty0(context.getAccessibleBean(), context.name);
            return true;
        }
    }

    class NestedContext {
        Object bean;
        String name;
        Object convertObject;
        Object value;
        NestedContext parent;
        boolean throwOnCycleReference;

        private NestedContext(NestedContext parent, String name, Object value) {
            this.parent = parent;
            this.name = name;
            this.value = value;
            this.throwOnCycleReference = parent.throwOnCycleReference;
        }

        private NestedContext(NestedContext parent, Object bean) {
            this.bean = bean;
            this.parent = parent;
            this.throwOnCycleReference = parent.throwOnCycleReference;
        }

        protected NestedContext(Object bean, String name, boolean throwOnCycleReference) {
            this.bean = bean;
            this.name = name;
            this.throwOnCycleReference = throwOnCycleReference;
        }

        protected NestedContext(Object bean, String name, Object value) {
            this.bean = bean;
            this.name = name;
            this.value = value;
        }

        private void normailzeBean(boolean throwOnfail) {
            if (null == this.convertObject && BeanPropertySupport.maybeJsonString(this.bean) > 0) {
                this.convertObject = JsonSupports.jsonSupportInstance().parseOrEmptyMap((String)this.bean, throwOnfail);
            }
        }

        Object getAccessibleBean() {
            return null == this.convertObject ? this.bean : this.convertObject;
        }

        Object visit(NestedNodeVisitor visitor) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (visitor.beforeVisit(this)) {
                return this.bean;
            }
            boolean hasNested = BeanPropertySupport.this.resolver.hasNested(this.name);
            boolean isIndexed = BeanPropertySupport.this.resolver.isIndexed(this.name);
            if (hasNested || isIndexed && this.name.charAt(0) != '[') {
                NestedContext nextContext;
                String propertyName;
                if (!hasNested && isIndexed && this.name.charAt(0) != '[') {
                    propertyName = BeanPropertySupport.this.resolver.getProperty(this.name);
                    String idx = this.name.replace(propertyName, "");
                    nextContext = new NestedContext(this, idx, this.value);
                } else {
                    propertyName = BeanPropertySupport.this.resolver.next(this.name);
                    nextContext = new NestedContext(this, this.name, this.value);
                    nextContext.name = BeanPropertySupport.this.resolver.remove(this.name);
                }
                this.normailzeBean(true);
                nextContext.bean = BeanPropertySupport.this.resolver.isMapped(propertyName) ? BeanPropertySupport.this.getMappedProperty(this.getAccessibleBean(), propertyName) : (BeanPropertySupport.this.resolver.isIndexed(propertyName) ? BeanPropertySupport.this.getIndexedProperty(this.getAccessibleBean(), propertyName) : (BeanPropertySupport.this.resolver.isSearched(propertyName) ? BeanPropertySupport.this.getSearchedProperty(this.getAccessibleBean(), propertyName) : BeanPropertySupport.this.getSimpleProperty(this.getAccessibleBean(), propertyName)));
                if (visitor.beofreNext(nextContext)) {
                    return nextContext.bean;
                }
                Object vret = nextContext.visit(visitor);
                if (visitor.afterNext(nextContext)) {
                    return this.bean;
                }
                return vret;
            }
            this.normailzeBean(true);
            if (visitor.lastNode(this)) {
                return this.value;
            }
            return null;
        }

        private boolean checkCycleRef(Object child) {
            NestedContext context = this;
            while (null != context) {
                if (child == context.bean) {
                    return true;
                }
                context = context.parent;
            }
            return false;
        }

        private String nestedName() {
            ArrayList<String> nestedNames = new ArrayList<String>(16);
            NestedContext cx = this;
            while (null != cx && null != cx.name) {
                nestedNames.add(cx.name);
                cx = cx.parent;
            }
            Collections.reverse(nestedNames);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < nestedNames.size(); ++i) {
                String name = (String)nestedNames.get(i);
                if (i > 0 && !name.startsWith("[")) {
                    builder.append('.');
                }
                builder.append(name);
            }
            return builder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int describe(Map<String, Object> nodes) {
            this.normailzeBean(false);
            List<String> names = this.getNames();
            if (names.isEmpty() && null == this.parent && null != nodes) {
                nodes.put(".", this.bean);
            }
            for (String name : names) {
                try {
                    this.name = name;
                    Object child = this.readValue();
                    if (this.checkCycleRef(child)) {
                        if (this.throwOnCycleReference) {
                            throw new CycleReferenceException(this.nestedName(), String.valueOf(child));
                        }
                        if (null == nodes) continue;
                        nodes.put(this.nestedName(), "<CycleReferenceException>");
                        continue;
                    }
                    NestedContext nestedContext = new NestedContext(this, child);
                    int cnt = nestedContext.describe(nodes);
                    if (0 != cnt || null == nodes) continue;
                    nodes.put(this.nestedName(), nestedContext.bean);
                }
                finally {
                    this.name = null;
                }
            }
            return names.size();
        }

        private List<String> getNames() {
            ArrayList<String> names = new ArrayList<String>(16);
            Object accessibleBean = this.getAccessibleBean();
            if (null != accessibleBean && !BeanPropertySupport.isBaseType(accessibleBean)) {
                if (accessibleBean instanceof Map) {
                    for (Object key : ((Map)accessibleBean).keySet()) {
                        if (!(key instanceof String)) continue;
                        names.add((String)key);
                    }
                } else if (accessibleBean instanceof List) {
                    int elementCount = ((List)accessibleBean).size();
                    for (int i = 0; i < elementCount; ++i) {
                        names.add("[" + i + "]");
                    }
                } else if (accessibleBean.getClass().isArray()) {
                    int elementCount = Array.getLength(accessibleBean);
                    for (int i = 0; i < elementCount; ++i) {
                        names.add("[" + i + "]");
                    }
                } else {
                    names.addAll(BeanPropertySupport.this.getPropertyNames(this.bean, 3, true));
                }
            }
            return names;
        }

        Object readValueChecked() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (null != this.name) {
                this.normailzeBean(false);
                Object accessibleBean = this.getAccessibleBean();
                if (null == accessibleBean) {
                    return null;
                }
                String next = BeanPropertySupport.this.resolver.hasNested(this.name) ? BeanPropertySupport.this.resolver.next(this.name) : this.name;
                return BeanPropertySupport.this.getProperty0(accessibleBean, next);
            }
            return this.bean;
        }

        Object readValue() {
            try {
                return this.readValueChecked();
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DiffNode {
        Object left;
        Object right;

        public DiffNode() {
        }

        public DiffNode(Object left, Object right) {
            this.left = left;
            this.right = right;
        }

        public Object getLeft() {
            return this.left;
        }

        public void setLeft(Object left) {
            this.left = left;
        }

        public Object getRight() {
            return this.right;
        }

        public void setRight(Object right) {
            this.right = right;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DiffNode [left=");
            builder.append(this.left);
            builder.append(", right=");
            builder.append(this.right);
            builder.append("]");
            return builder.toString();
        }
    }
}

