/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.bean;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameResolver {
    private static final char NESTED = '.';
    private static final char MAPPED_START = '(';
    private static final char MAPPED_END = ')';
    private static final char INDEXED_START = '[';
    private static final char INDEXED_END = ']';
    private static final String INDEXED_REGEX = "(.*)\\[([-+]|LAST|FIRST|[-+]?\\d+)\\]";
    private static final String SEARCHED_REGEX = "(.*)\\[(\\S+?)\\=(\\S+?)\\]";

    public int getIndex(String expression) {
        if (expression == null || expression.length() == 0) {
            return -3;
        }
        for (int i = 0; i < expression.length(); ++i) {
            int index;
            char c = expression.charAt(i);
            if (c == '.' || c == '(') {
                return -3;
            }
            if (c != '[') continue;
            int end = expression.indexOf(93, i);
            if (end < 0) {
                throw new IllegalArgumentException("Missing End Delimiter");
            }
            String value = expression.substring(i + 1, end);
            if (value.length() == 0) {
                throw new IllegalArgumentException("No Index Value");
            }
            switch (value) {
                case "-": 
                case "FIRST": {
                    index = -1;
                    break;
                }
                case "+": 
                case "LAST": {
                    index = -2;
                    break;
                }
                default: {
                    try {
                        index = Integer.parseInt(value, 10);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid index value '" + value + "'");
                    }
                }
            }
            return index;
        }
        return -3;
    }

    public String getKey(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '.' || c == '[') {
                return null;
            }
            if (c != '(') continue;
            int end = expression.indexOf(41, i);
            if (end < 0) {
                throw new IllegalArgumentException("Missing End Delimiter");
            }
            return expression.substring(i + 1, end);
        }
        return null;
    }

    public String getField(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Matcher matcher = Pattern.compile(SEARCHED_REGEX).matcher(expression);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public String getValue(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Matcher matcher = Pattern.compile(SEARCHED_REGEX).matcher(expression);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return null;
    }

    public String getProperty(String expression) {
        if (expression == null || expression.length() == 0) {
            return expression;
        }
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '.') {
                return expression.substring(0, i);
            }
            if (c != '(' && c != '[') continue;
            return expression.substring(0, i);
        }
        return expression;
    }

    public boolean hasNested(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return this.remove(expression) != null;
    }

    public boolean isIndexed(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return expression.matches(INDEXED_REGEX);
    }

    public boolean isSearched(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return expression.matches(SEARCHED_REGEX);
    }

    public boolean isMapped(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '.' || c == '[') {
                return false;
            }
            if (c != '(') continue;
            return true;
        }
        return false;
    }

    public String next(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        boolean indexed = false;
        boolean mapped = false;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (indexed) {
                if (c != ']') continue;
                return expression.substring(0, i + 1);
            }
            if (mapped) {
                if (c != ')') continue;
                return expression.substring(0, i + 1);
            }
            if (c == '.') {
                return expression.substring(0, i);
            }
            if (c == '(') {
                mapped = true;
                continue;
            }
            if (c != '[') continue;
            indexed = true;
        }
        return expression;
    }

    public String nextRight(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        boolean indexed = false;
        boolean mapped = false;
        boolean startMatch = false;
        for (int i = expression.length() - 1; i >= 0; --i) {
            char c = expression.charAt(i);
            if (indexed) {
                if (startMatch) {
                    if (c != ')' && c != ']' && c != '.') continue;
                    return expression.substring(i + 1);
                }
                if (c != '[') continue;
                startMatch = true;
                continue;
            }
            if (mapped) {
                if (startMatch) {
                    if (c != ')' && c != ']' && c != '.') continue;
                    return expression.substring(i + 1);
                }
                if (c != '(') continue;
                startMatch = true;
                continue;
            }
            if (c == '.') {
                return expression.substring(i + 1);
            }
            if (c == ')') {
                mapped = true;
                continue;
            }
            if (c != ']') continue;
            indexed = true;
        }
        return expression;
    }

    public String remove(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        String property = this.next(expression);
        if (expression.length() == property.length()) {
            return null;
        }
        int start = property.length();
        if (expression.charAt(start) == '.') {
            ++start;
        }
        return expression.substring(start);
    }

    public String removeRight(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        String property = this.nextRight(expression);
        if (expression.length() == property.length()) {
            return null;
        }
        int end = expression.length() - property.length();
        if (expression.charAt(end - 1) == '.') {
            --end;
        }
        return expression.substring(0, end);
    }
}

