/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.bean.jdk;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.gdface.reflection.MethodUtils;

class BeanIntrospectionData {
    private final PropertyDescriptor[] descriptors;
    private final Map<String, String> writeMethodNames;
    private final Map<String, Integer> indexMap;

    public BeanIntrospectionData(PropertyDescriptor[] descs) {
        this(descs, BeanIntrospectionData.setUpWriteMethodNames(descs));
    }

    BeanIntrospectionData(PropertyDescriptor[] descs, Map<String, String> writeMethNames) {
        this.descriptors = descs;
        this.indexMap = BeanIntrospectionData.setIndexMap(this.descriptors);
        this.writeMethodNames = writeMethNames;
    }

    public PropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public PropertyDescriptor getDescriptor(String name) {
        Integer index = this.indexMap.get(name);
        if (null != index) {
            return this.getDescriptors()[index];
        }
        return null;
    }

    public Method getWriteMethod(Class<?> beanCls, PropertyDescriptor desc) {
        String methodName;
        Method method = desc.getWriteMethod();
        if (method == null && (methodName = this.writeMethodNames.get(desc.getName())) != null && (method = MethodUtils.getAccessibleMethod(beanCls, methodName, desc.getPropertyType())) != null) {
            try {
                desc.setWriteMethod(method);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return method;
    }

    private static Map<String, String> setUpWriteMethodNames(PropertyDescriptor[] descs) {
        HashMap<String, String> methods = new HashMap<String, String>();
        for (PropertyDescriptor pd : descs) {
            Method method = pd.getWriteMethod();
            if (method == null) continue;
            methods.put(pd.getName(), method.getName());
        }
        return methods;
    }

    private static Map<String, Integer> setIndexMap(PropertyDescriptor[] descs) {
        LinkedHashMap<String, Integer> descriptors = new LinkedHashMap<String, Integer>(descs.length);
        for (int i = 0; i < descs.length; ++i) {
            descriptors.put(descs[i].getName(), i);
        }
        return descriptors;
    }
}

