/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.bean.jdk;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.gdface.annotations.ActiveOnClass;
import net.gdface.bean.BeanPropertySupport;
import net.gdface.bean.NameResolver;
import net.gdface.bean.exception.BeanPropertyRuntimeException;
import net.gdface.bean.exception.CycleReferenceException;
import net.gdface.bean.exception.NestedNullException;
import net.gdface.bean.jdk.BeanIntrospectionData;
import net.gdface.bean.jdk.InvokeMewthodContext;
import net.gdface.bean.jdk.descriptor.FieldPropertyDescriptor;
import net.gdface.bean.jdk.descriptor.LenientDecoratorOfDescriptor;
import net.gdface.bean.jdk.descriptor.MappedPropertyDescriptor;
import net.gdface.bean.jdk.descriptor.NoStandardPropertyDescriptor;
import net.gdface.bean.jdk.factory.PropertyDescriptorFactories;
import net.gdface.bean.jdk.factory.PropertyDescriptorFactory;
import net.gdface.json.JsonSupports;
import net.gdface.logger.SimpleLogger;
import net.gdface.reflection.MethodUtils;

@ActiveOnClass(value={PropertyDescriptor.class})
public class BeanPropertySupportImpl
extends BeanPropertySupport {
    private static final Logger logger = SimpleLogger.getLogger(BeanPropertySupportImpl.class.getSimpleName());
    public static final BeanPropertySupportImpl BEAN_SUPPORT = new BeanPropertySupportImpl();
    private final LoadingCache<Class<?>, BeanIntrospectionData> descriptorsCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(new CacheLoader<Class<?>, BeanIntrospectionData>(){

        public BeanIntrospectionData load(Class<?> key) throws Exception {
            return BeanPropertySupportImpl.this.getIntrospectionData0(key);
        }
    });
    private final Cache<String, Map<String, PropertyDescriptor>> mappedDescriptorsCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final NameResolver resolver = new NameResolver();
    private final PropertyDescriptorFactories propertyDescriptorFactories = new PropertyDescriptorFactories();

    private BeanIntrospectionData getIntrospectionData0(Class<?> beanClass) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        LinkedList<PropertyDescriptor> descriptorList = new LinkedList<PropertyDescriptor>(Arrays.asList(descriptors));
        LinkedList<Field> fields = new LinkedList<Field>(Arrays.asList(beanClass.getFields()));
        Iterator itor = fields.iterator();
        block0: while (itor.hasNext()) {
            Field next = (Field)itor.next();
            if (Modifier.isStatic(next.getModifiers())) {
                itor.remove();
                continue;
            }
            for (PropertyDescriptor pd : descriptorList) {
                if (!pd.getName().equals(next.getName())) continue;
                if (!pd.getPropertyType().equals(next.getType())) {
                    throw new IntrospectionException("FIND Field with save name: " + next.getName() + ",but mismatch Type " + next.getType());
                }
                itor.remove();
                continue block0;
            }
        }
        for (Field field : fields) {
            descriptorList.add(new FieldPropertyDescriptor(field));
        }
        return new BeanIntrospectionData(descriptorList.toArray(new PropertyDescriptor[descriptorList.size()]));
    }

    private BeanIntrospectionData getIntrospectionData(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        try {
            return (BeanIntrospectionData)this.descriptorsCache.get(beanClass);
        }
        catch (ExecutionException e) {
            throw new BeanPropertyRuntimeException(e.getCause());
        }
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        return this.getIntrospectionData(beanClass).getDescriptors();
    }

    private HashMap<String, PropertyDescriptor> getProperties0(Class<?> beanClass, int rw, boolean lenient) {
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        if (beanClass != null) {
            PropertyDescriptor[] origDescriptors;
            for (PropertyDescriptor pd : origDescriptors = this.getPropertyDescriptors(beanClass)) {
                if (lenient && !(pd instanceof NoStandardPropertyDescriptor) && 2 == (rw & 2)) {
                    pd = LenientDecoratorOfDescriptor.toDecorator(pd);
                }
                Boolean put = false;
                switch (rw &= 3) {
                    case 1: {
                        put = BeanPropertySupportImpl.hasReadMethod(pd);
                        break;
                    }
                    case 2: {
                        put = BeanPropertySupportImpl.hasWriteMethod(pd);
                        break;
                    }
                    case 0: 
                    case 3: {
                        put = BeanPropertySupportImpl.hasReadMethod(pd) && BeanPropertySupportImpl.hasWriteMethod(pd);
                    }
                }
                if (!put.booleanValue()) continue;
                properties.put(pd.getName(), pd);
            }
        }
        return properties;
    }

    public Map<String, PropertyDescriptor> getProperties(final Class<?> beanClass, final int rw, final boolean lenient) {
        if (null != beanClass) {
            try {
                String key = String.format("%s_%d_%b", beanClass.getName(), rw, lenient);
                return (Map)this.mappedDescriptorsCache.get((Object)key, (Callable)new Callable<Map<String, PropertyDescriptor>>(){

                    @Override
                    public Map<String, PropertyDescriptor> call() throws Exception {
                        return BeanPropertySupportImpl.this.getProperties0(beanClass, rw, lenient);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new BeanPropertyRuntimeException(e.getCause());
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, PropertyDescriptor> getMappedPropertyDescriptors(Class<?> beanClass) {
        return this.getProperties(beanClass, 3, true);
    }

    public Map<String, PropertyDescriptor> getMappedPropertyDescriptors(Object bean) {
        if (bean == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean.getClass());
    }

    @Override
    public Set<String> getPropertyNames(Class<?> beanClass, int rw, boolean lenient) {
        if (null != beanClass) {
            return Sets.newLinkedHashSet(this.getProperties(beanClass, rw, lenient).keySet());
        }
        return Collections.emptySet();
    }

    @Override
    public void clearDescriptors() {
        this.descriptorsCache.asMap().clear();
        this.mappedDescriptorsCache.asMap().clear();
        Introspector.flushCaches();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(bean.getClass());
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor result;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = this.getPropertyChecked(bean, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        if ((name = this.resolver.getProperty(name)) == null) {
            return null;
        }
        try {
            result = this.propertyDescriptorFactories.nostandardDescriptorOf(bean, name);
            if (result != null) {
                return result;
            }
        }
        catch (IntrospectionException nestedBean) {
            // empty catch block
        }
        result = this.getIntrospectionData(bean.getClass()).getDescriptor(name);
        if (result != null) {
            return result;
        }
        Map<String, PropertyDescriptor> mappedDescriptors = this.getMappedPropertyDescriptors(bean);
        result = mappedDescriptors.get(name);
        if (result == null) {
            try {
                result = this.propertyDescriptorFactories.builtinDescriptorOf(bean, name);
                if (null == result) {
                    result = new MappedPropertyDescriptor(name, bean.getClass());
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (result != null && !(bean instanceof Map) && !(bean instanceof Iterable)) {
                mappedDescriptors.put(name, result);
            }
        }
        return result;
    }

    @Override
    protected Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isSearched(name)) {
            throw new IllegalArgumentException("Search property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean.getClass() + "'");
        }
        return this.invokeMethod(descriptor, readMethod, bean, EMPTY_OBJECT_ARRAY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class " + bean.getClass() + "'");
        }
        Object result = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor).getMappedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object[] keyArray = new Object[]{key};
            return this.invokeMethod(descriptor, readMethod, bean, keyArray);
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
        Object invokeResult = this.invokeMethod(descriptor, readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (!(invokeResult instanceof Map)) return result;
        return ((Map)invokeResult).get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setMappedProperty(Object bean, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            mappedWriteMethod = MethodUtils.getAccessibleMethod(bean.getClass(), mappedWriteMethod);
            if (mappedWriteMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped setter methodon bean class '" + bean.getClass() + "'");
            Object[] params = new Object[]{key, value};
            if (traceEnabled) {
                String valueClassName = value == null ? "<null>" : value.getClass().getName();
                logger.info("setSimpleProperty: Invoking method " + mappedWriteMethod + " with key=" + key + ", value=" + value + " (class " + valueClassName + ")");
            }
            this.invokeMethod(descriptor, mappedWriteMethod, bean, params);
            return;
        } else {
            Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object invokeResult = this.invokeMethod(descriptor, readMethod, bean, EMPTY_OBJECT_ARRAY);
            if (!(invokeResult instanceof Map)) return;
            ((Map)invokeResult).put(key, value);
        }
    }

    @Override
    protected Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            return this.getIndexValue("", bean, index);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod != null) {
                Object[] subscript = new Object[]{new Integer(-1 == index ? 0 : index)};
                try {
                    return this.invokeMethod(descriptor, readMethod, bean, subscript);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)e.getTargetException();
                    }
                    throw e;
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(descriptor, readMethod, bean, EMPTY_OBJECT_ARRAY);
        return this.getIndexValue(name, value, index);
    }

    @Override
    protected void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> propertyType;
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            this.setOrAddIndexValue(name, bean, index, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            Method writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod();
            writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
            if (writeMethod != null) {
                Object[] subscript = new Object[]{new Integer(index), value};
                try {
                    if (traceEnabled) {
                        String valueClassName = value == null ? "<null>" : value.getClass().getName();
                        logger.info("setSimpleProperty: Invoking method " + writeMethod + " with index=" + index + ", value=" + value + " (class " + valueClassName + ")");
                    }
                    this.invokeMethod(descriptor, writeMethod, bean, subscript);
                }
                catch (InvocationTargetException e) {
                    Throwables.throwIfInstanceOf((Throwable)e.getTargetException(), IndexOutOfBoundsException.class);
                    throw e;
                }
                return;
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        LinkedList array = this.invokeMethod(descriptor, readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (null == array && (Object.class == (propertyType = descriptor.getPropertyType()) || null == propertyType)) {
            array = new LinkedList();
            Method writeMethod = this.getWriteMethod(bean.getClass(), descriptor);
            if (writeMethod == null) {
                throw new NoSuchMethodException("Property '" + name + "' has no setter method on bean class '" + bean.getClass() + "'");
            }
            this.invokeMethod(descriptor, writeMethod, bean, new Object[]{array});
        }
        this.setOrAddIndexValue(name, array, index, value);
    }

    @Override
    protected Object getSearchedProperty(Object bean, String name, String field, Object conditionValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            return this.searchIn(bean, field, conditionValue);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            throw new UnsupportedOperationException("UNSUPPORT IndexedPropertyDescriptor for search property");
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(descriptor, readMethod, bean, EMPTY_OBJECT_ARRAY);
        return this.searchIn(value, field, conditionValue);
    }

    @Override
    protected void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isSearched(name)) {
            throw new IllegalArgumentException("Searched property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method writeMethod = this.getWriteMethod(bean.getClass(), descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method in class '" + bean.getClass() + "'");
        }
        if (traceEnabled) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            logger.info("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")");
        }
        Class<?> propertyType = descriptor.getPropertyType();
        if (null != value) {
            Object old;
            if (!propertyType.isInstance(value)) {
                Object old2;
                if (String.class.equals(propertyType)) {
                    Object parsed;
                    Object old3 = this.getProperty0(bean, name);
                    Map oldjson = new LinkedHashMap();
                    if (BeanPropertySupportImpl.maybeJsonString(old3) > 0 && (parsed = JsonSupports.jsonSupportInstance().parseOrEmptyMap((String)old3, false)) instanceof Map) {
                        oldjson = (Map)parsed;
                    }
                    this.copyProperties(oldjson, value);
                    value = JsonSupports.jsonSupportInstance().toJSONString(oldjson);
                } else if (value instanceof String) {
                    value = JsonSupports.jsonSupportInstance().parse((String)value, propertyType);
                } else if (Map.class.isInstance(value) && Map.class.isAssignableFrom(propertyType) && null != (old2 = this.getProperty0(bean, name))) {
                    ((Map)old2).putAll((Map)value);
                    value = old2;
                }
            } else if (String.class.equals(propertyType)) {
                Object old4 = this.getProperty0(bean, name);
                if (BeanPropertySupportImpl.maybeJsonString(old4) > 0 && BeanPropertySupportImpl.maybeJsonString(value) > 0) {
                    Object oldparsed = JsonSupports.jsonSupportInstance().parseOrEmptyMap((String)old4);
                    Object valueparsed = JsonSupports.jsonSupportInstance().parseOrEmptyMap((String)value);
                    if (oldparsed instanceof Map && valueparsed instanceof Map) {
                        ((Map)oldparsed).putAll((Map)valueparsed);
                        value = JsonSupports.jsonSupportInstance().toJSONString(oldparsed);
                    }
                }
            } else if (Map.class.isAssignableFrom(propertyType) && null != (old = this.getProperty0(bean, name))) {
                this.copyProperties(old, value);
                value = old;
            }
        }
        this.invokeMethod(descriptor, writeMethod, bean, new Object[]{value});
    }

    private Method getReadMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        if (descriptor instanceof NoStandardPropertyDescriptor) {
            return ((NoStandardPropertyDescriptor)((Object)descriptor)).getReadMethod(clazz, descriptor);
        }
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    private Method getWriteMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        if (descriptor instanceof NoStandardPropertyDescriptor) {
            return ((NoStandardPropertyDescriptor)((Object)descriptor)).getWriteMethod(clazz, descriptor);
        }
        BeanIntrospectionData data = this.getIntrospectionData(clazz);
        return MethodUtils.getAccessibleMethod(clazz, data.getWriteMethod(clazz, descriptor));
    }

    @Override
    public void copyProperties(Object dest, Object orig) {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof Map) {
            for (Map.Entry entry : ((Map)orig).entrySet()) {
                String name = (String)entry.getKey();
                if (!this.isWriteable(dest, name)) continue;
                try {
                    this.setSimpleProperty(dest, name, entry.getValue());
                }
                catch (NoSuchMethodException e) {
                    if (!traceEnabled) continue;
                    logger.log(Level.INFO, "Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!this.isReadable(orig, name) || !this.isWriteable(dest, name)) continue;
                try {
                    Object value = this.getSimpleProperty(orig, name);
                    this.setSimpleProperty(dest, name, value);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    if (!traceEnabled) continue;
                    logger.log(Level.INFO, "Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public boolean isReadable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getPropertyChecked(bean, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method readMethod = this.getReadMethod(bean.getClass(), desc);
                if (readMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        readMethod = ((MappedPropertyDescriptor)desc).getMappedReadMethod();
                    }
                    readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public boolean isWriteable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getPropertyChecked(bean, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method writeMethod = this.getWriteMethod(bean.getClass(), desc);
                if (writeMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        writeMethod = ((IndexedPropertyDescriptor)desc).getIndexedWriteMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        writeMethod = ((MappedPropertyDescriptor)desc).getMappedWriteMethod();
                    }
                    writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public boolean hasCycleReference(Object bean) {
        try {
            this.checkCycleReference(bean);
            return false;
        }
        catch (CycleReferenceException e) {
            return true;
        }
    }

    @Override
    protected Object tryConstructIfNull(Object nestedBean, Object bean, String name, Class<?> expectType) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor descriptor;
        if (null != nestedBean) {
            return nestedBean;
        }
        if (null == bean) {
            throw new NullPointerException("bean is null");
        }
        if (BeanPropertySupportImpl.isEmpty(name)) {
            throw new NullPointerException("name is null or empty");
        }
        try {
            descriptor = this.getPropertyDescriptor(bean, name);
            if (null == descriptor) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
            }
        }
        catch (ReflectiveOperationException e) {
            throw new BeanPropertyRuntimeException(e);
        }
        try {
            if (null == expectType) {
                expectType = descriptor.getPropertyType();
                if (List.class.equals(expectType)) {
                    expectType = ArrayList.class;
                } else if (Set.class.equals(expectType)) {
                    expectType = LinkedHashSet.class;
                } else if (Map.class.equals(expectType)) {
                    expectType = LinkedHashMap.class;
                }
            }
            String newBean = String.class.equals(expectType) ? "{}" : expectType.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.setProperty0(bean, name, newBean);
            return newBean;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "',AND FAIL to try construct new instance", e);
        }
    }

    private Object invokeMethod(Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        if (bean == null && !NoStandardPropertyDescriptor.class.isAssignableFrom(method.getDeclaringClass())) {
            throw new IllegalArgumentException("No bean specified - this should have been checked before reaching this method");
        }
        try {
            return method.invoke(bean, values);
        }
        catch (NullPointerException cause) {
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\"", cause);
            throw e;
        }
        catch (IllegalArgumentException cause) {
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\"", cause);
            throw e;
        }
    }

    private Object invokeMethod(PropertyDescriptor descriptor, Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        if (descriptor instanceof NoStandardPropertyDescriptor) {
            InvokeMewthodContext context = new InvokeMewthodContext(descriptor, method, bean, values);
            ((NoStandardPropertyDescriptor)((Object)descriptor)).beforeInvokeMethod(context);
            return this.invokeMethod(method, context.bean, context.values);
        }
        return this.invokeMethod(method, bean, values);
    }

    private static boolean hasReadMethod(PropertyDescriptor propertyDescriptor) {
        return null != propertyDescriptor && null != propertyDescriptor.getReadMethod();
    }

    private static boolean hasWriteMethod(PropertyDescriptor propertyDescriptor) {
        return null != propertyDescriptor && null != propertyDescriptor.getWriteMethod();
    }

    public void addPropertyDescriptorFactoryAsFirst(PropertyDescriptorFactory element) {
        this.propertyDescriptorFactories.addFirst(element);
    }

    public void addPropertyDescriptorFactory(PropertyDescriptorFactory element) {
        this.propertyDescriptorFactories.add(element);
    }
}

