/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.bean.jdk.descriptor;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.Map;
import net.gdface.bean.jdk.descriptor.BaseNoStandardPropertyDescriptor;

public class MapPropertyDescriptor
extends BaseNoStandardPropertyDescriptor {
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<?> propertyType;

    public MapPropertyDescriptor(Class<?> propertyType, String name) throws IntrospectionException {
        super(MapPropertyDescriptor.checkNotNull(name, "field is null").replace(".", "_"), null, null);
        this.setDisplayName(name);
        this.propertyType = null == propertyType ? Object.class : propertyType;
        try {
            this.readMethod = MapPropertyDescriptor.class.getMethod("readMethod", Object.class, String.class);
            this.writeMethod = MapPropertyDescriptor.class.getMethod("writeMethod", Object.class, String.class, Object.class);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object readMethod(Object bean, String name) {
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        return null;
    }

    public static void writeMethod(Object bean, String name, Object value) {
        if (bean instanceof Map) {
            Map map = (Map)bean;
            if (null == value) {
                map.remove(map);
            } else {
                map.put(name, value);
            }
        }
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    private static <T> T checkNotNull(T object, String message) {
        if (null == object) {
            throw new NullPointerException(message);
        }
        return object;
    }
}

