/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.bean.openbeans.descriptor;

import com.google.common.base.Preconditions;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.PropertyDescriptor;
import gu.sql2java.BaseRow;
import gu.sql2java.RowMetaData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.gdface.bean.DescriptorUtils;
import net.gdface.reflection.MethodUtils;
import net.gdface.utils.CaseSupport;

public class BaseRowPropertyDescriptor
extends PropertyDescriptor {
    private static final Class<?>[] EMPTY_PARAMETER = new Class[0];
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<?> propertyType;

    public BaseRowPropertyDescriptor(String name, BaseRow bean) throws IntrospectionException {
        super((String)Preconditions.checkNotNull((Object)name, (Object)"field is null"), null, null);
        Class<?> beanClass = ((BaseRow)Preconditions.checkNotNull((Object)bean, (Object)"bean is null")).getClass();
        Class<?> fieldType = BaseRowPropertyDescriptor.typeOf((Class)Preconditions.checkNotNull(beanClass, (Object)"beanClass is null"), name);
        RowMetaData metaData = bean.fetchMetaData();
        Class columnType = metaData.columnTypeOf(name);
        String columnName = metaData.columnNameOf(metaData.columnIDOf(name));
        if (fieldType.equals(columnType)) {
            Method method;
            try {
                method = BaseRowPropertyDescriptor.getMethod(beanClass, CaseSupport.toCamelcase("get_" + columnName), EMPTY_PARAMETER);
            }
            catch (IntrospectionException e) {
                method = BaseRowPropertyDescriptor.getMethod(beanClass, CaseSupport.toCamelcase("is_" + columnName), EMPTY_PARAMETER);
            }
            this.readMethod = method;
            this.writeMethod = BaseRowPropertyDescriptor.getMethod(beanClass, CaseSupport.toCamelcase("set_" + columnName), new Class[]{columnType});
            this.propertyType = columnType;
        } else {
            this.readMethod = BaseRowPropertyDescriptor.getMethod(beanClass, CaseSupport.toCamelcase("read_" + columnName), EMPTY_PARAMETER);
            this.writeMethod = BaseRowPropertyDescriptor.getMethod(beanClass, CaseSupport.toCamelcase("write_" + columnName), new Class[]{fieldType});
            this.propertyType = fieldType;
        }
    }

    private static Class<?> typeOf(Class<?> beanClass, String name) {
        Field field = DescriptorUtils.fieldOf(beanClass, name);
        return null == field ? null : field.getType();
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        int parameterCount = parameterTypes == null ? 0 : parameterTypes.length;
        throw new IntrospectionException("No method \"" + methodName + "\" with " + parameterCount + " parameter(s) of matching types.");
    }
}

