/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.bean.openbeans.factory;

import com.google.common.collect.ImmutableList;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.gdface.annotations.ActiveOnClass;
import net.gdface.annotations.AnnotationSupport;
import net.gdface.bean.openbeans.factory.BaseRowDescriptorFactory;
import net.gdface.bean.openbeans.factory.FieldDescriptorFactory;
import net.gdface.bean.openbeans.factory.MapDescriptorFactory;
import net.gdface.bean.openbeans.factory.PropertyDescriptorFactory;
import net.gdface.bean.openbeans.factory.UnnameRowDescriptorFactory;

public class PropertyDescriptorFactories
implements PropertyDescriptorFactory {
    private final List<PropertyDescriptorFactory> builtinDescriptorFactorys;
    private final List<PropertyDescriptorFactory> nostandardDescriptorFactorys = new ArrayList<PropertyDescriptorFactory>();

    public PropertyDescriptorFactories() {
        this.builtinDescriptorFactorys = ImmutableList.of((Object)new MapDescriptorFactory(), (Object)new FieldDescriptorFactory());
        for (Class clazz : Arrays.asList(UnnameRowDescriptorFactory.class, BaseRowDescriptorFactory.class)) {
            PropertyDescriptorFactory instance = (PropertyDescriptorFactory)AnnotationSupport.createInstanceIfActiveClassPresent(clazz);
            if (null == instance) continue;
            this.nostandardDescriptorFactorys.add(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(PropertyDescriptorFactory element) {
        if (null != element) {
            PropertyDescriptorFactories propertyDescriptorFactories = this;
            synchronized (propertyDescriptorFactories) {
                this.builtinDescriptorFactorys.add(0, element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PropertyDescriptorFactory element) {
        if (null != element) {
            PropertyDescriptorFactories propertyDescriptorFactories = this;
            synchronized (propertyDescriptorFactories) {
                this.builtinDescriptorFactorys.add(element);
            }
        }
    }

    private boolean isActive(ActiveOnClass activeOnClass, Object bean) {
        if (null != activeOnClass) {
            for (Class<?> clazz : activeOnClass.value()) {
                if (!clazz.isInstance(bean)) continue;
                return true;
            }
            for (String clazzName : activeOnClass.name()) {
                if (!clazzName.equals(bean.getClass().getName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public PropertyDescriptor descriptorOf(Object bean, String name) throws IntrospectionException {
        PropertyDescriptor descriptor = this.nostandardDescriptorOf(bean, name);
        if (null != descriptor) {
            return descriptor;
        }
        return this.builtinDescriptorOf(bean, name);
    }

    public PropertyDescriptor nostandardDescriptorOf(Object bean, String name) throws IntrospectionException {
        for (PropertyDescriptorFactory factory : this.nostandardDescriptorFactorys) {
            PropertyDescriptor descriptor;
            ActiveOnClass activeOnClass = factory.getClass().getAnnotation(ActiveOnClass.class);
            if (!this.isActive(activeOnClass, bean) || null == (descriptor = factory.descriptorOf(bean, name))) continue;
            return descriptor;
        }
        return null;
    }

    public PropertyDescriptor builtinDescriptorOf(Object bean, String name) throws IntrospectionException {
        for (PropertyDescriptorFactory factory : this.builtinDescriptorFactorys) {
            PropertyDescriptor descriptor;
            ActiveOnClass activeOnClass = factory.getClass().getAnnotation(ActiveOnClass.class);
            if (!this.isActive(activeOnClass, bean) || null == (descriptor = factory.descriptorOf(bean, name))) continue;
            return descriptor;
        }
        return null;
    }
}

