/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import net.gdface.annotations.ActiveOnClass;
import net.gdface.json.JsonSupport;
import net.gdface.json.JsonSupportException;

@ActiveOnClass(value={JSON.class})
public class FastJsonSupport
extends JsonSupport {
    private final SerializerFeature[] features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNonStringKeyAsString};
    private final SerializerFeature[] indent = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNonStringKeyAsString, SerializerFeature.PrettyFormat};

    @Override
    public String toJSONString(Object object, boolean prettyFormat) throws JsonSupportException {
        try {
            return JSON.toJSONString((Object)object, (SerializerFeature[])(prettyFormat ? this.indent : this.features));
        }
        catch (JSONException e) {
            throw new JsonSupportException(e);
        }
    }

    @Override
    public Object parseOrEmptyMap(String json) throws JsonSupportException {
        try {
            if (null == json || 0 == json.length()) {
                return new JSONObject(true);
            }
            return JSON.parseObject((String)json, JSON.class);
        }
        catch (JSONException e) {
            throw new JsonSupportException(e);
        }
    }

    @Override
    public <T> T parse(String json, Class<T> targetType) throws JsonSupportException {
        try {
            if (null == json || 0 == json.length()) {
                return null;
            }
            return (T)JSON.parseObject((String)json, targetType);
        }
        catch (Exception e) {
            throw new JsonSupportException(e);
        }
    }
}

