/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import net.gdface.annotations.ActiveOnClass;
import net.gdface.json.JsonSupport;
import net.gdface.json.JsonSupportException;

@ActiveOnClass(value={ObjectMapper.class})
public class JacksonSupport
extends JsonSupport {
    private final ObjectMapper deserializeMapper = new ObjectMapper();
    private final ObjectMapper serializeIndentMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
    private final ObjectMapper serializeMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, false);

    @Override
    public String toJSONString(Object object, boolean prettyFormat) throws JsonSupportException {
        ObjectMapper mapper = prettyFormat ? this.serializeIndentMapper : this.serializeMapper;
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonSupportException(e);
        }
    }

    @Override
    public Object parseOrEmptyMap(String json) throws JsonSupportException {
        try {
            if (null == json || 0 == json.length()) {
                return new LinkedHashMap();
            }
            switch (JacksonSupport.maybeJsonString(json)) {
                case 1: {
                    return this.deserializeMapper.readValue(json, LinkedHashMap.class);
                }
                case 2: {
                    return this.deserializeMapper.readValue(json, LinkedList.class);
                }
            }
            throw new JsonSupportException("NONE A JSON :" + json);
        }
        catch (JsonProcessingException e) {
            throw new JsonSupportException(e);
        }
        catch (IOException e) {
            throw new JsonSupportException(e);
        }
    }

    @Override
    public <T> T parse(String json, Class<T> targetType) throws JsonSupportException {
        if (null == json || 0 == json.length()) {
            return null;
        }
        try {
            return (T)this.deserializeMapper.readValue(json, targetType);
        }
        catch (JsonProcessingException e) {
            throw new JsonSupportException(e);
        }
        catch (IOException e) {
            throw new JsonSupportException(e);
        }
    }

    private static int maybeJsonString(Object object) {
        String s;
        if (object instanceof String && (s = (String)object).length() > 1) {
            if (s.charAt(0) == '{' && s.charAt(s.length() - 1) == '}') {
                return 1;
            }
            if (s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                return 2;
            }
        }
        return 0;
    }
}

