/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SimpleConsoleFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = "\n" + sw.toString();
        }
        Thread currentThread = Thread.currentThread();
        StackTraceElement stackTrace = currentThread.getStackTrace()[8];
        return String.format("[%s] (%s:%d) %s%s\n", Thread.currentThread().getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), message, throwable);
    }

    public static Logger installFormatter(Logger logger) {
        if (null != logger) {
            logger.setUseParentHandlers(false);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new SimpleConsoleFormatter());
            logger.addHandler(consoleHandler);
        }
        return logger;
    }
}

