/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;

public class ArraySupport {
    public static final String toHex(byte[] input) {
        if (null == input) {
            return null;
        }
        return BaseEncoding.base16().encode(input);
    }

    public static final String toHex(short[] input) {
        if (null == input) {
            return null;
        }
        byte[][] output = new byte[input.length][];
        for (int i = 0; i < input.length; ++i) {
            output[i] = Shorts.toByteArray((short)input[i]);
        }
        return ArraySupport.toHex(Bytes.concat((byte[][])output));
    }

    public static final String toHex(int[] input) {
        if (null == input) {
            return null;
        }
        byte[][] output = new byte[input.length][];
        for (int i = 0; i < input.length; ++i) {
            output[i] = Ints.toByteArray((int)input[i]);
        }
        return ArraySupport.toHex(Bytes.concat((byte[][])output));
    }

    public static final String toHex(long[] input) {
        if (null == input) {
            return null;
        }
        byte[][] output = new byte[input.length][];
        for (int i = 0; i < input.length; ++i) {
            output[i] = Longs.toByteArray((long)input[i]);
        }
        return ArraySupport.toHex(Bytes.concat((byte[][])output));
    }

    public static final byte[] fromHex(String input) {
        if (null == input) {
            return null;
        }
        return BaseEncoding.base16().decode((CharSequence)input);
    }

    public static final short[] fromHex(String input, short value) {
        int step;
        if (null == input) {
            return null;
        }
        byte[] bytes = ArraySupport.fromHex(input);
        Preconditions.checkArgument((0 == bytes.length % (step = 2) ? 1 : 0) != 0, (String)"INVALID input length %s,%s times required", (int)input.length(), (int)step);
        short[] output = new short[bytes.length % step];
        int i = 0;
        int j = 0;
        while (i < output.length) {
            output[i] = Shorts.fromBytes((byte)bytes[j], (byte)bytes[j + 1]);
            ++i;
            j += step;
        }
        return output;
    }

    public static final int[] fromHex(String input, int value) {
        int step;
        if (null == input) {
            return null;
        }
        byte[] bytes = ArraySupport.fromHex(input);
        Preconditions.checkArgument((0 == bytes.length % (step = 4) ? 1 : 0) != 0, (String)"INVALID input length %s,%s times required", (int)input.length(), (int)step);
        int[] output = new int[bytes.length % step];
        int i = 0;
        int j = 0;
        while (i < output.length) {
            output[i] = Ints.fromBytes((byte)bytes[j], (byte)bytes[j + 1], (byte)bytes[j + 2], (byte)bytes[j + 3]);
            ++i;
            j += step;
        }
        return output;
    }

    public static final long[] fromHex(String input, long value) {
        int step;
        if (null == input) {
            return null;
        }
        byte[] bytes = ArraySupport.fromHex(input);
        Preconditions.checkArgument((0 == bytes.length % (step = 8) ? 1 : 0) != 0, (String)"INVALID input length %s,%s times required", (int)input.length(), (int)step);
        long[] output = new long[bytes.length % step];
        int i = 0;
        int j = 0;
        while (i < output.length) {
            output[i] = Longs.fromBytes((byte)bytes[j], (byte)bytes[j + 1], (byte)bytes[j + 2], (byte)bytes[j + 3], (byte)bytes[j + 4], (byte)bytes[j + 5], (byte)bytes[j + 6], (byte)bytes[j + 7]);
            ++i;
            j += step;
        }
        return output;
    }

    public static void copyToByteArray(String hex, byte[] dest) {
        Preconditions.checkArgument((null != hex && null != dest ? 1 : 0) != 0, (Object)"hex or dest is null");
        byte[] src = ArraySupport.fromHex(hex);
        Preconditions.checkArgument((src.length == dest.length ? 1 : 0) != 0, (String)"INVALID HEX String length, %s required", (int)dest.length);
        System.arraycopy(src, 0, dest, 0, src.length);
    }
}

